/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.time.Instant;
import java.util.Collection;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import mil.army.usace.hec.data.timeseries.TextTimeSeries;
import mil.army.usace.hec.data.timeseries.TextTimeSeriesImpl;
import mil.army.usace.hec.data.timeseries.TextTimeSeriesRow;
import mil.army.usace.hec.data.timeseries.VersionDate;
import mil.army.usace.hec.metadata.DataSetException;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;

public final class TextTimeSeriesBuilder {
    private final TimeSeriesIdentifier _timeSeriesIdentifier;
    private final NavigableMap<Instant, TextTimeSeriesRow> _rows = new TreeMap<Instant, TextTimeSeriesRow>();
    private VersionDate _versionDate;

    public TextTimeSeriesBuilder(TimeSeriesIdentifier timeSeriesIdentifier) {
        this._timeSeriesIdentifier = Objects.requireNonNull(timeSeriesIdentifier, "Cannot build a Text time series without an identifier");
    }

    public TextTimeSeriesBuilder withRows(Collection<TextTimeSeriesRow> rows) {
        rows.forEach(r -> this._rows.put(r.getTime(), (TextTimeSeriesRow)r));
        return this;
    }

    public TextTimeSeriesBuilder withRow(TextTimeSeriesRow row) {
        this._rows.put(row.getTime(), row);
        return this;
    }

    public TextTimeSeriesBuilder withVersionDate(VersionDate versionDate) {
        this._versionDate = versionDate;
        return this;
    }

    public TextTimeSeries build() throws DataSetException {
        this.validateRowIntervals();
        return new TextTimeSeriesImpl(this._timeSeriesIdentifier, this._rows, this._versionDate);
    }

    private void validateRowIntervals() throws DataSetIllegalArgumentException, DataSetTimeSeriesException {
        Optional<TextTimeSeriesRow> invalidRow;
        if (this._rows.isEmpty()) {
            return;
        }
        if (!this._timeSeriesIdentifier.getIntervalOffset().isNoOffset() && !this._timeSeriesIdentifier.getIntervalOffset().isDefined()) {
            Instant time = (Instant)this._rows.firstKey();
            this._timeSeriesIdentifier.updateUndefinedIntervalOffsetWithStartTime(time);
        }
        if ((invalidRow = this._rows.values().stream().filter(r -> !this._timeSeriesIdentifier.isOnInterval(r.getTime())).findFirst()).isPresent()) {
            throw new DataSetTimeSeriesException(String.format("Text time series rows do not correspond to the time series identifier interval and offset: %s %nrow: %s", this._timeSeriesIdentifier, invalidRow.get()));
        }
    }
}

