/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.time.Instant;
import mil.army.usace.hec.data.timeseries.TextTimeSeriesRow;
import mil.army.usace.hec.data.timeseries.TextTimeSeriesRowImpl;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.web.MediaType;

public final class TextTimeSeriesRowBuilder {
    private Instant _valueDate;
    private Instant _dataEntryDate;
    private MediaType _mediaType;
    private String _value;
    private String _fileName;
    private int _quality;

    public TextTimeSeriesRowBuilder withValueDate(Instant valueDate) {
        this._valueDate = valueDate;
        return this;
    }

    public TextTimeSeriesRowBuilder withDataEntryDate(Instant dataEntryDate) {
        this._dataEntryDate = dataEntryDate;
        return this;
    }

    public TextTimeSeriesRowBuilder withMediaType(MediaType mediaType) {
        this._mediaType = mediaType;
        return this;
    }

    public TextTimeSeriesRowBuilder withValue(String value) {
        this._value = value;
        return this;
    }

    public TextTimeSeriesRowBuilder withFileName(String fileName) {
        this._fileName = fileName;
        return this;
    }

    public TextTimeSeriesRowBuilder withQuality(int quality) {
        this._quality = quality;
        return this;
    }

    public TextTimeSeriesRow build() throws DataSetIllegalArgumentException {
        if (this._value == null) {
            throw new DataSetIllegalArgumentException("Binary time series row value cannot be null. Use an empty array");
        }
        if (this._mediaType == null) {
            throw new DataSetIllegalArgumentException("Binary time series row media type cannot be null.");
        }
        if (this._valueDate == null) {
            throw new DataSetIllegalArgumentException("Binary time series row value date cannot be null.");
        }
        if (this._fileName == null) {
            throw new DataSetIllegalArgumentException("Binary time series row value filename cannot be null.");
        }
        return new TextTimeSeriesRowImpl(this._valueDate, this._value, this._fileName, this._mediaType, this._dataEntryDate, this._quality);
    }
}

