/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import mil.army.usace.hec.data.timeseries.TextTimeSeriesRow;
import mil.army.usace.hec.metadata.web.MediaType;

class TextTimeSeriesRowImpl
implements TextTimeSeriesRow {
    private final Instant _time;
    private final String _value;
    private final String _fileName;
    private final MediaType _mediaType;
    private final Instant _dataEntryDate;
    private final int _quality;

    TextTimeSeriesRowImpl(Instant time, String value, String fileName, MediaType mediaType, Instant dataEntryDate, int quality) {
        this._time = time;
        this._value = value;
        this._fileName = fileName;
        this._mediaType = mediaType;
        this._dataEntryDate = dataEntryDate;
        this._quality = quality;
    }

    @Override
    public Instant getTime() {
        return this._time;
    }

    @Override
    public String getValue() {
        return this._value;
    }

    @Override
    public String getFileName() {
        return this._fileName;
    }

    @Override
    public MediaType getMediaType() {
        return this._mediaType;
    }

    @Override
    public Optional<Instant> getDataEntryDate() {
        return Optional.ofNullable(this._dataEntryDate);
    }

    @Override
    public int getQuality() {
        return this._quality;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextTimeSeriesRowImpl that = (TextTimeSeriesRowImpl)o;
        return Objects.equals(this._time, that._time) && Objects.equals(this._value, that._value) && Objects.equals(this._fileName, that._fileName) && Objects.equals(this._mediaType, that._mediaType) && Objects.equals(this._dataEntryDate, that._dataEntryDate) && Objects.equals(this._quality, that._quality);
    }

    public int hashCode() {
        return Objects.hash(this._time, this._value, this._fileName, this._mediaType, this._dataEntryDate, this._quality);
    }

    public String toString() {
        return "TextTimeSeriesRowImpl{_time=" + this._time + ", _value='" + this._value + "', _fileName='" + this._fileName + "', _mediaType=" + this._mediaType + ", _dataEntryDate=" + this._dataEntryDate + ", _quality=" + this._quality + "}";
    }
}

