/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import mil.army.usace.hec.data.timeseries.DataSetTimeSeriesDeriveException;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TimeSeriesStatistics;
import mil.army.usace.hec.data.timeseries.TimeValueSeries;
import mil.army.usace.hec.data.timeseries.VersionDate;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.DataSetException;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.Units;
import mil.army.usace.hec.metadata.UnitsConversionException;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesException;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.IntervalOffsetMismatchException;

public interface TimeSeries
extends Serializable,
TimeValueSeries {
    public TimeSeriesStatistics getTimeSeriesStatistics();

    public void set(long[] var1, double[] var2, Quality var3) throws DataSetTimeSeriesIllegalArgumentException, IntervalOffsetMismatchException, DataSetIllegalArgumentException;

    public NavigableMap<ZonedDateTime, Double> getData();

    public NavigableMap<ZonedDateTime, Double> getData(ZoneId var1);

    public NavigableMap<Date, Double> getDateValueNavigableMap();

    public double[] getValues();

    public void trim() throws DataSetTimeSeriesIllegalArgumentException;

    public double[] getValuesWithQualityFlagsApplied();

    public int getIndexOfLatestValidValue();

    public Optional<Quality> getQuality();

    @Override
    public Optional<VersionDate> getVersionDate();

    public boolean hasQuality();

    public void addEmptyQualityTx();

    public long[] getTimes();

    public NavigableSet<Instant> getInstants();

    public int getNumberValues();

    public boolean isSameTimeWindow(TimeSeries var1);

    public boolean needToChangeUnits(Units var1) throws DataSetTimeSeriesDeriveException;

    public void changeUnits(Units var1) throws DataSetTimeSeriesDeriveException;

    public void changeUnitSystem(String var1) throws UnitsConversionException, DataSetIllegalArgumentException, DataSetTimeSeriesException;

    public void changeUnitSystem(int var1) throws DataSetTimeSeriesException, UnitsConversionException, DataSetIllegalArgumentException;

    public void window(TimeSeriesTemplate var1) throws DataSetTimeSeriesDeriveException;

    public void fillTails(TimeSeriesTemplate var1) throws DataSetTimeSeriesException, DataSetIllegalArgumentException;

    public void trimTail();

    public void removeRejectedAndMissingValues(boolean var1) throws DataSetTimeSeriesException, DataSetIllegalArgumentException, IntervalOffsetMismatchException;

    public TimeSeries generateDifferences(TimeSeries var1) throws DataSetException;

    default public Optional<VerticalDatum> getVerticalDatum() {
        return Optional.empty();
    }

    public Units getUnits();

    public void setUnits(Units var1);

    public ZonedDateTime getStartTime();

    public ZonedDateTime getEndTime();

    public boolean getPreserveRejectedAndMissingValues();

    public void setPreserveRejectedAndMissingValues(boolean var1);

    public void setMaxTimeGap(long var1);

    public long getMaxTimeGap();

    public boolean isOkay(int var1);

    public boolean isMissing(int var1);

    public boolean isEmpty();
}

