/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.time.Instant;
import java.util.Arrays;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.TimeSeriesWithVerticalDatum;
import mil.army.usace.hec.data.timeseries.VersionDate;
import mil.army.usace.hec.data.timeseries.VersionDateFactory;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.DataSetException;
import mil.army.usace.hec.metadata.Units;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import rma.util.lookup.Lookups;

public abstract class TimeSeriesBuilder {
    private final TimeSeriesIdentifier _timeSeriesIdentifier;
    private final TimeSeriesTemplate _timeSeriesTemplate;
    private final Units _units;
    private VerticalDatumContainer _verticalDatumContainer;
    private VersionDate _versionDate;
    private Quality _quality;
    private double[] _values = new double[0];
    private long[] _times = new long[0];
    private Instant _startTime = Instant.ofEpochMilli(Long.MIN_VALUE);
    private Instant _endTime = Instant.ofEpochMilli(Long.MIN_VALUE);
    private long _maxTimeGap;
    private boolean _preserveRejectedAndMissingValues = true;

    protected TimeSeriesBuilder(TimeSeriesIdentifier timeSeriesIdentifier, Units units) {
        this._timeSeriesIdentifier = timeSeriesIdentifier;
        this._timeSeriesTemplate = null;
        this._units = units;
    }

    protected TimeSeriesBuilder(TimeSeriesTemplate timeSeriesTemplate, Units units) {
        this._timeSeriesTemplate = timeSeriesTemplate;
        this._timeSeriesIdentifier = null;
        this._units = units;
    }

    public static TimeSeriesBuilder createBuilder(TimeSeriesIdentifier timeSeriesIdentifier, Units units) {
        return ((TimeSeriesBuilderCreator)Lookups.forPath((String)timeSeriesIdentifier.getTimeSeriesLookupPath()).lookup(TimeSeriesBuilderCreator.class)).create(timeSeriesIdentifier, units);
    }

    public static TimeSeriesBuilder builder(TimeSeries original) throws DataSetException {
        long[] times = original.getTimes();
        double[] values = original.getValues();
        VersionDate versionDate = original.getVersionDate().map(VersionDateFactory::copy).orElse(null);
        Quality quality = original.getQuality().map(Quality::new).orElse(null);
        VerticalDatumContainer verticalDatumContainer = original.getVerticalDatum().map(VerticalDatum::getVerticalDatumContainer).orElse(null);
        return ((TimeSeriesBuilderCreator)Lookups.forPath((String)original.getTimeSeriesIdentifier().getTimeSeriesLookupPath()).lookup(TimeSeriesBuilderCreator.class)).create(original.getTimeSeriesIdentifier(), original.getUnits()).withValues(Arrays.copyOf(values, values.length)).withTimes(Arrays.copyOf(times, times.length)).withTimeWindow(original.getStartTime().toInstant(), original.getEndTime().toInstant()).withQuality(quality).withVersionDate(versionDate).withVerticalDatum(verticalDatumContainer).withMaxTimeGap(original.getMaxTimeGap()).withPreserveRejectedAndMissingValues(original.getPreserveRejectedAndMissingValues());
    }

    public static TimeSeries copy(TimeSeries original) throws DataSetException {
        return TimeSeriesBuilder.builder(original).build();
    }

    protected TimeSeriesIdentifier timeSeriesIdentifier() {
        return this._timeSeriesIdentifier;
    }

    protected TimeSeriesTemplate timeSeriesTemplate() {
        return this._timeSeriesTemplate;
    }

    protected Units units() {
        return this._units;
    }

    public TimeSeriesBuilder withTimeWindow(Instant startTime, Instant endTime) {
        this._startTime = startTime;
        this._endTime = endTime;
        return this;
    }

    protected Instant startTime() {
        return this._startTime;
    }

    protected Instant endTime() {
        return this._endTime;
    }

    public TimeSeriesBuilder withValues(double[] values) {
        this._values = values;
        return this;
    }

    protected double[] values() {
        return this._values;
    }

    public TimeSeriesBuilder withTimes(long[] times) {
        this._times = times;
        return this;
    }

    protected long[] times() {
        return this._times;
    }

    public TimeSeriesBuilder withQuality(Quality quality) {
        this._quality = quality;
        return this;
    }

    protected Quality quality() {
        return this._quality;
    }

    public TimeSeriesBuilder withPreserveRejectedAndMissingValues(boolean preserveRejectedAndMissingValues) {
        this._preserveRejectedAndMissingValues = preserveRejectedAndMissingValues;
        return this;
    }

    protected boolean preserveRejectedAndMissingValues() {
        return this._preserveRejectedAndMissingValues;
    }

    public TimeSeriesBuilder withVersionDate(VersionDate versionDate) {
        this._versionDate = versionDate;
        return this;
    }

    protected VersionDate versionDate() {
        return this._versionDate;
    }

    public TimeSeriesBuilder withMaxTimeGap(long maxTimeGap) {
        this._maxTimeGap = maxTimeGap;
        return this;
    }

    protected long maxTimeGap() {
        return this._maxTimeGap;
    }

    public TimeSeriesBuilder withVerticalDatum(VerticalDatumContainer verticalDatumContainer) {
        this._verticalDatumContainer = verticalDatumContainer;
        return this;
    }

    protected VerticalDatumContainer verticalDatum() {
        return this._verticalDatumContainer;
    }

    protected TimeSeries wrapVerticalDatum(TimeSeries timeSeries) {
        if (this.verticalDatum() != null) {
            timeSeries = new TimeSeriesWithVerticalDatum(timeSeries, this.verticalDatum());
        }
        return timeSeries;
    }

    public abstract TimeSeries build() throws DataSetException;

    static interface TimeSeriesBuilderCreator {
        public TimeSeriesBuilder create(TimeSeriesIdentifier var1, Units var2);
    }
}

