/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import mil.army.usace.hec.data.timeseries.AnnotatedTimeValueSeries;
import mil.army.usace.hec.data.timeseries.BinaryTimeSeries;
import mil.army.usace.hec.data.timeseries.BinaryTimeSeriesBuilder;
import mil.army.usace.hec.data.timeseries.BinaryTimeSeriesRowBuilder;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TextTimeSeries;
import mil.army.usace.hec.data.timeseries.TextTimeSeriesBuilder;
import mil.army.usace.hec.data.timeseries.TextTimeSeriesRowBuilder;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.TimeSeriesBuilder;
import mil.army.usace.hec.data.timeseries.TimeSeriesWithVerticalDatum;
import mil.army.usace.hec.data.timeseries.TimeValueSeries;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.DataSetException;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import mil.army.usace.hec.metadata.web.MediaType;
import rma.util.lookup.Lookups;

public final class TimeSeriesFactory {
    private TimeSeriesFactory() {
        throw new AssertionError((Object)"Utility class");
    }

    public static TimeSeries buildTimeSeries(TimeSeriesTemplate template) throws DataSetException {
        if (template == null) {
            throw new DataSetTimeSeriesIllegalArgumentException("Unable to build a time series from a null template");
        }
        return ((TimeSeriesBuilder.TimeSeriesBuilderCreator)Lookups.forPath((String)template.getTimeSeriesIdentifier().getTimeSeriesLookupPath()).lookup(TimeSeriesBuilder.TimeSeriesBuilderCreator.class)).create(template.getTimeSeriesIdentifier(), template.getUnits()).build();
    }

    public static TimeSeries buildTimeSeries(TimeSeriesTemplate template, long startTime, double[] values, Quality quality) throws DataSetException {
        return TimeSeriesFactory.buildTimeSeries(template, startTime, values, quality, null);
    }

    public static TimeSeries buildTimeSeries(TimeSeriesTemplate template, long startTime, double[] values, Quality quality, VerticalDatumContainer verticalDatumContainer) throws DataSetException {
        if (template == null) {
            throw new DataSetTimeSeriesIllegalArgumentException("Unable to build a time series from a null template");
        }
        TimeSeriesIdentifier timeSeriesIdentifier = template.getTimeSeriesIdentifier();
        return ((TimeSeriesBuilder.TimeSeriesBuilderCreator)Lookups.forPath((String)timeSeriesIdentifier.getTimeSeriesLookupPath()).lookup(TimeSeriesBuilder.TimeSeriesBuilderCreator.class)).create(template.getTimeSeriesIdentifier(), template.getUnits()).withTimes(new long[]{startTime}).withValues(values).withQuality(quality).withTimeWindow(Instant.ofEpochMilli(template.getStartTime()), Instant.ofEpochMilli(template.getEndTime())).withMaxTimeGap(template.getMaxTimeGapMillis()).withPreserveRejectedAndMissingValues(template.getPreserveRejectedAndMissingValues()).withVerticalDatum(verticalDatumContainer).build();
    }

    public static TimeSeries buildTimeSeries(TimeSeriesTemplate template, long[] times, double[] values, Quality quality) throws DataSetException {
        if (template == null) {
            throw new DataSetTimeSeriesIllegalArgumentException("Unable to build a time series from a null template");
        }
        return ((TimeSeriesBuilder.TimeSeriesBuilderCreator)Lookups.forPath((String)template.getTimeSeriesIdentifier().getTimeSeriesLookupPath()).lookup(TimeSeriesBuilder.TimeSeriesBuilderCreator.class)).create(template.getTimeSeriesIdentifier(), template.getUnits()).withTimes(times).withValues(values).withQuality(quality).withPreserveRejectedAndMissingValues(template.getPreserveRejectedAndMissingValues()).withMaxTimeGap(template.getMaxTimeGapMillis()).withTimeWindow(Instant.ofEpochMilli(template.getStartTime()), Instant.ofEpochMilli(template.getEndTime())).build();
    }

    public static TimeSeries copy(TimeSeries original) throws DataSetException {
        return TimeSeriesBuilder.copy(original);
    }

    public static TimeSeries buildTimeSeries(TimeSeries timeSeries, VerticalDatumContainer verticalDatumContainer) {
        return new TimeSeriesWithVerticalDatum(timeSeries, verticalDatumContainer);
    }

    public static TimeSeries buildTimeSeries(TimeSeriesTemplate template, VerticalDatumContainer verticalDatumContainer) throws DataSetException {
        TimeSeries timeSeries = TimeSeriesFactory.buildTimeSeries(template);
        return new TimeSeriesWithVerticalDatum(timeSeries, verticalDatumContainer);
    }

    public static TimeSeries buildTimeSeries(TimeSeriesTemplate template, long[] times, double[] values, Quality quality, VerticalDatumContainer verticalDatumContainer) throws DataSetException {
        TimeSeries timeSeries = TimeSeriesFactory.buildTimeSeries(template, times, values, quality);
        if (verticalDatumContainer != null) {
            return new TimeSeriesWithVerticalDatum(timeSeries, verticalDatumContainer);
        }
        return timeSeries;
    }

    public static BinaryTimeSeries buildBinaryTimeSeries(TimeSeriesIdentifier timeSeriesIdentifier, List<Instant> times, List<byte[]> values, List<String> fileNames, MediaType mediaType) throws DataSetException {
        Object[] mediaTypes = new MediaType[values.size()];
        if (!values.isEmpty()) {
            Arrays.fill(mediaTypes, mediaType);
        }
        return TimeSeriesFactory.buildBinaryTimeSeries(timeSeriesIdentifier, times, values, fileNames, Arrays.asList(mediaTypes));
    }

    public static BinaryTimeSeries buildBinaryTimeSeries(TimeSeriesIdentifier timeSeriesIdentifier, List<Instant> times, List<byte[]> values, List<String> fileNames, List<MediaType> mediaType) throws DataSetException {
        BinaryTimeSeriesBuilder builder = new BinaryTimeSeriesBuilder(timeSeriesIdentifier);
        int timeCount = times.size();
        int valueCount = values.size();
        int mediaTypeCount = mediaType.size();
        int fileNameCount = fileNames.size();
        if (timeCount != valueCount || valueCount != mediaTypeCount || valueCount != fileNameCount) {
            String message = String.format("Cannot generate binary time series with times list size %s and value list size %s and media type list size %s", timeCount, valueCount, mediaTypeCount);
            throw new DataSetTimeSeriesIllegalArgumentException(message);
        }
        BinaryTimeSeriesRowBuilder rowBuilder = new BinaryTimeSeriesRowBuilder();
        for (int i = 0; i < timeCount; ++i) {
            builder.withRow(rowBuilder.withValueDate(times.get(i)).withValue(values.get(i)).withMediaType(mediaType.get(i)).withFileName(fileNames.get(i)).build());
        }
        return builder.build();
    }

    public static TextTimeSeries buildTextTimeSeries(TimeSeriesIdentifier timeSeriesIdentifier, List<Instant> times, List<String> values, List<String> fileNames, MediaType mediaType) throws DataSetException {
        Object[] mediaTypes = new MediaType[values.size()];
        if (!values.isEmpty()) {
            Arrays.fill(mediaTypes, mediaType);
        }
        return TimeSeriesFactory.buildTextTimeSeries(timeSeriesIdentifier, times, values, fileNames, Arrays.asList(mediaTypes));
    }

    public static TextTimeSeries buildTextTimeSeries(TimeSeriesIdentifier timeSeriesIdentifier, List<Instant> times, List<String> values, List<String> fileNames, List<MediaType> mediaType) throws DataSetException {
        TextTimeSeriesBuilder builder = new TextTimeSeriesBuilder(timeSeriesIdentifier);
        int timeCount = times.size();
        int valueCount = values.size();
        int mediaTypeCount = mediaType.size();
        int fileNameCount = fileNames.size();
        if (timeCount != valueCount || valueCount != mediaTypeCount || valueCount != fileNameCount) {
            String message = String.format("Cannot generate text time series with times list size %s and value list size %s and media type list size %s", timeCount, valueCount, mediaTypeCount);
            throw new DataSetTimeSeriesIllegalArgumentException(message);
        }
        TextTimeSeriesRowBuilder rowBuilder = new TextTimeSeriesRowBuilder();
        for (int i = 0; i < timeCount; ++i) {
            builder.withRow(rowBuilder.withValueDate(times.get(i)).withValue(values.get(i)).withMediaType(mediaType.get(i)).withFileName(fileNames.get(i)).build());
        }
        return builder.build();
    }

    public static <T extends TimeValueSeries> AnnotatedTimeValueSeries<T> buildAnnotatedTimeSeries(T timeValueSeries, BinaryTimeSeries binaryTimeSeries, TextTimeSeries textTimeSeries) {
        return new AnnotatedTimeValueSeries<T>(timeValueSeries, binaryTimeSeries, textTimeSeries);
    }

    public static <T extends TimeValueSeries> AnnotatedTimeValueSeries<T> buildAnnotatedTimeSeries(T timeValueSeries, BinaryTimeSeries binaryTimeSeries) {
        return new AnnotatedTimeValueSeries<T>(timeValueSeries, binaryTimeSeries, null);
    }

    public static <T extends TimeValueSeries> AnnotatedTimeValueSeries<T> buildAnnotatedTimeSeries(T timeValueSeries, TextTimeSeries textTimeSeries) {
        return new AnnotatedTimeValueSeries<T>(timeValueSeries, null, textTimeSeries);
    }
}

