/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.TimeZone;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.metadata.constants.NumericalConstants;

public class TimeSeriesPrinter {
    private static final String[] PAD_BLANKS = new String[]{"               ", "              ", "             ", "            ", "           ", "          ", "         ", "        ", "       ", "      ", "     ", "    ", "   ", "  ", " ", ""};
    private final TimeSeries _timeSeries;

    public TimeSeriesPrinter(TimeSeries timeSeries) {
        this._timeSeries = timeSeries;
    }

    public void tabulateValues(TimeZone timeZone) {
        String numberFormatPattern = ".0";
        double absMinNonZeroValue = this._timeSeries.getTimeSeriesStatistics().getAbsMinNonZeroValue();
        if (absMinNonZeroValue < 1.0) {
            numberFormatPattern = ".00";
        }
        if (absMinNonZeroValue < 0.1) {
            numberFormatPattern = ".000";
        }
        if (absMinNonZeroValue < 0.01) {
            numberFormatPattern = ".0000";
        }
        if (absMinNonZeroValue < 0.001) {
            numberFormatPattern = ".00000";
        }
        if (absMinNonZeroValue < 1.0E-4) {
            numberFormatPattern = ".000000";
        }
        if (absMinNonZeroValue < 1.0E-5) {
            numberFormatPattern = ".0000000";
        }
        this.tabulateValues(timeZone, numberFormatPattern);
    }

    public void tabulateValues(TimeZone timeZone, String numberFormatPattern) {
        DecimalFormat df = new DecimalFormat(numberFormatPattern);
        long[] times = this._timeSeries.getTimes();
        System.out.println("\n=====>Tabulation of DataSetTx for: <" + this._timeSeries.getTimeSeriesIdentifier().toString() + ">");
        System.out.println(super.toString());
        System.out.println("   -->Number of Values: " + this._timeSeries.getNumberValues());
        if (this._timeSeries.getValues().length > 0) {
            SimpleDateFormat sdfFULL = NumericalConstants.sdfFULL();
            System.out.println("   -->Number of Values Okay: " + this._timeSeries.getTimeSeriesStatistics().getNumberValuesOkay());
            System.out.println("   -->Number of Values Missing: " + this._timeSeries.getTimeSeriesStatistics().getNumberValuesMissing());
            System.out.println("   -->Number of Values Rejected: " + this._timeSeries.getTimeSeriesStatistics().getNumberValuesReject());
            System.out.println("   -->Number of Values Questioned: " + this._timeSeries.getTimeSeriesStatistics().getNumberValuesQuestion());
            System.out.println("   -->Number of Values Protected: " + this._timeSeries.getTimeSeriesStatistics().getNumberValuesProtected());
            System.out.println("   -->  [Max, Min, Ave do not include 'Missing' or 'Rejected' values]");
            System.out.println("   -->Max. Value = " + this._timeSeries.getTimeSeriesStatistics().getMaxValue() + "  at: " + sdfFULL.format(new Date(this._timeSeries.getTimeSeriesStatistics().getMaxValueTime())));
            System.out.println("   -->Min. Value = " + this._timeSeries.getTimeSeriesStatistics().getMinValue() + "  at: " + sdfFULL.format(new Date(this._timeSeries.getTimeSeriesStatistics().getMinValueTime())));
            System.out.println("   -->Ave. Value = " + this._timeSeries.getTimeSeriesStatistics().getAveValue());
            System.out.println("   -->Abs. Min. Non-Zero Value = " + this._timeSeries.getTimeSeriesStatistics().getAbsMinNonZeroValue());
            System.out.println("   -->Tabulation Number Format: " + df.toPattern());
            SimpleDateFormat sdf = new SimpleDateFormat(" dd MMM yyyy  HH:mm:ss z");
            sdf.setTimeZone(timeZone);
            if (this._timeSeries.hasQuality()) {
                System.out.println(" Date/Time(" + timeZone.getID() + ")         Value                 Hex        Bin");
            } else {
                System.out.println(" Date/Time(" + timeZone.getID() + ")         Value");
            }
            Date d = null;
            String valuesString = null;
            String tag = null;
            String pad = null;
            String pro = null;
            Optional<Quality> quality = this._timeSeries.getQuality();
            for (int i = 0; i < this._timeSeries.getValues().length; ++i) {
                d = new Date(times[i]);
                tag = " ";
                pad = " ";
                if (i + 1 < 1000000) {
                    pad = "  ";
                }
                if (i + 1 < 100000) {
                    pad = "   ";
                }
                if (i + 1 < 10000) {
                    pad = "    ";
                }
                if (i + 1 < 1000) {
                    pad = "     ";
                }
                if (i + 1 < 100) {
                    pad = "      ";
                }
                if (i + 1 < 10) {
                    pad = "       ";
                }
                if (this._timeSeries.isMissing(i)) {
                    tag = "M";
                }
                if (quality.isPresent() && quality.get().isReject(i)) {
                    tag = "R";
                }
                if (quality.isPresent() && quality.get().isQuestion(i)) {
                    tag = "Q";
                }
                pro = "  ";
                if (quality.isPresent() && quality.get().isProtected(i)) {
                    pro = " P";
                }
                if ((valuesString = this._timeSeries.getValues()[i] == -3.4028234663852886E38 ? " -Unk-" : df.format(this._timeSeries.getValues()[i])).length() > PAD_BLANKS.length) continue;
                if (quality.isPresent()) {
                    System.out.println(" " + (i + 1) + pad + sdf.format(d) + "   " + valuesString + PAD_BLANKS[valuesString.length()] + pro + tag + "      " + quality.get().toHexStringElementAt(i) + "   " + quality.get().toBinaryStringElementAt(i));
                    continue;
                }
                System.out.println(" " + (i + 1) + pad + sdf.format(d) + "   " + valuesString);
            }
        } else {
            System.out.println("\n " + this._timeSeries.getTimeSeriesIdentifier().toString() + " is an EMPTY DATASET\n");
        }
    }

    public void tabulateValues() {
        this.tabulateValues(TimeZone.getDefault());
    }

    public void tabulateStatistics(TimeZone timeZone) {
        String numberFormatPattern = ".0";
        double absMinNonZeroValue = this._timeSeries.getTimeSeriesStatistics().getAbsMinNonZeroValue();
        if (absMinNonZeroValue < 1.0) {
            numberFormatPattern = ".00";
        }
        if (absMinNonZeroValue < 0.1) {
            numberFormatPattern = ".000";
        }
        if (absMinNonZeroValue < 0.01) {
            numberFormatPattern = ".0000";
        }
        if (absMinNonZeroValue < 0.001) {
            numberFormatPattern = ".00000";
        }
        if (absMinNonZeroValue < 1.0E-4) {
            numberFormatPattern = ".000000";
        }
        if (absMinNonZeroValue < 1.0E-5) {
            numberFormatPattern = ".0000000";
        }
        this.tabulateStatistics(timeZone, numberFormatPattern);
    }

    public void tabulateStatistics(TimeZone timeZone, String numberFormatPattern) {
        DecimalFormat df = new DecimalFormat(numberFormatPattern);
        long[] times = this._timeSeries.getTimes();
        System.out.println("\n=====>Tabulation of DataSetTx for: <" + this._timeSeries.getTimeSeriesIdentifier().toString() + ">");
        System.out.println(super.toString());
        System.out.println("   -->Number of Values: " + this._timeSeries.getNumberValues());
        if (this._timeSeries.getValues().length > 0) {
            int i;
            SimpleDateFormat sdfFULL = NumericalConstants.sdfFULL();
            System.out.println("   -->Number of Values Okay: " + this._timeSeries.getTimeSeriesStatistics().getNumberValuesOkay());
            System.out.println("   -->Number of Values Missing: " + this._timeSeries.getTimeSeriesStatistics().getNumberValuesMissing());
            System.out.println("   -->Number of Values Rejected: " + this._timeSeries.getTimeSeriesStatistics().getNumberValuesReject());
            System.out.println("   -->Number of Values Questioned: " + this._timeSeries.getTimeSeriesStatistics().getNumberValuesQuestion());
            System.out.println("   -->Number of Values Protected: " + this._timeSeries.getTimeSeriesStatistics().getNumberValuesProtected());
            System.out.println("   -->  [Max, Min, Ave do not include 'Missing' or 'Rejected' values]");
            System.out.println("   -->Max. Value = " + this._timeSeries.getTimeSeriesStatistics().getMaxValue() + "  at: " + sdfFULL.format(new Date(this._timeSeries.getTimeSeriesStatistics().getMaxValueTime())));
            System.out.println("   -->Min. Value = " + this._timeSeries.getTimeSeriesStatistics().getMinValue() + "  at: " + sdfFULL.format(new Date(this._timeSeries.getTimeSeriesStatistics().getMinValueTime())));
            System.out.println("   -->Ave. Value = " + this._timeSeries.getTimeSeriesStatistics().getAveValue());
            System.out.println("   -->Abs. Min. Non-Zero Value = " + this._timeSeries.getTimeSeriesStatistics().getAbsMinNonZeroValue());
            System.out.println("   -->Tabulation Number Format: " + df.toPattern());
            SimpleDateFormat sdf = new SimpleDateFormat(" dd MMM yyyy  HHmm z");
            sdf.setTimeZone(timeZone);
            if (this._timeSeries.hasQuality()) {
                System.out.println(" Date/Time(" + timeZone.getID() + ")     Value                 Hex        Bin");
            } else {
                System.out.println(" Date/Time(" + timeZone.getID() + ")     Value");
            }
            Date d = null;
            String valuesString = null;
            String tag = null;
            String pad = null;
            String pro = null;
            int numTab = Math.min(5, this._timeSeries.getValues().length);
            Optional<Quality> quality = this._timeSeries.getQuality();
            for (i = 0; i < numTab; ++i) {
                d = new Date(times[i]);
                tag = " ";
                pad = " ";
                if (i + 1 < 1000000) {
                    pad = "  ";
                }
                if (i + 1 < 100000) {
                    pad = "   ";
                }
                if (i + 1 < 10000) {
                    pad = "    ";
                }
                if (i + 1 < 1000) {
                    pad = "     ";
                }
                if (i + 1 < 100) {
                    pad = "      ";
                }
                if (i + 1 < 10) {
                    pad = "       ";
                }
                if (this._timeSeries.isMissing(i)) {
                    tag = "M";
                }
                if (quality.isPresent() && quality.get().isReject(i)) {
                    tag = "R";
                }
                if (quality.isPresent() && quality.get().isQuestion(i)) {
                    tag = "Q";
                }
                pro = "  ";
                if (quality.isPresent() && quality.get().isProtected(i)) {
                    pro = " P";
                }
                if ((valuesString = this._timeSeries.getValues()[i] == -3.4028234663852886E38 ? " -Unk-" : df.format(this._timeSeries.getValues()[i])).length() > PAD_BLANKS.length) continue;
                if (quality.isPresent()) {
                    System.out.println(" " + (i + 1) + pad + sdf.format(d) + "   " + valuesString + PAD_BLANKS[valuesString.length()] + pro + tag + "      " + quality.get().toHexStringElementAt(i) + "   " + quality.get().toBinaryStringElementAt(i));
                    continue;
                }
                System.out.println(" " + (i + 1) + pad + sdf.format(d) + "   " + valuesString);
            }
            System.out.println("          . . .");
            System.out.println("          . . .");
            System.out.println("          . . .");
            for (i = this._timeSeries.getValues().length - numTab; i < this._timeSeries.getValues().length; ++i) {
                d = new Date(times[i]);
                tag = " ";
                pad = " ";
                if (i + 1 < 1000000) {
                    pad = "  ";
                }
                if (i + 1 < 100000) {
                    pad = "   ";
                }
                if (i + 1 < 10000) {
                    pad = "    ";
                }
                if (i + 1 < 1000) {
                    pad = "     ";
                }
                if (i + 1 < 100) {
                    pad = "      ";
                }
                if (i + 1 < 10) {
                    pad = "       ";
                }
                if (this._timeSeries.isMissing(i)) {
                    tag = "M";
                }
                if (quality.isPresent() && quality.get().isReject(i)) {
                    tag = "R";
                }
                if (quality.isPresent() && quality.get().isQuestion(i)) {
                    tag = "Q";
                }
                pro = "  ";
                if (quality.isPresent() && quality.get().isProtected(i)) {
                    pro = " P";
                }
                if ((valuesString = this._timeSeries.getValues()[i] == -3.4028234663852886E38 ? " -Unk-" : df.format(this._timeSeries.getValues()[i])).length() > PAD_BLANKS.length) continue;
                if (quality.isPresent()) {
                    System.out.println(" " + (i + 1) + pad + sdf.format(d) + "   " + valuesString + PAD_BLANKS[valuesString.length()] + pro + tag + "      " + quality.get().toHexStringElementAt(i) + "   " + quality.get().toBinaryStringElementAt(i));
                    continue;
                }
                System.out.println(" " + (i + 1) + pad + sdf.format(d) + "   " + valuesString);
            }
        } else {
            System.out.println("\n " + this._timeSeries.getTimeSeriesIdentifier().toString() + " is an EMPTY DATASET\n");
        }
    }

    public void tabulateStatistics() {
        this.tabulateStatistics(TimeZone.getDefault());
    }
}

