/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.io.Serializable;
import java.util.Optional;
import mil.army.usace.hec.data.timeseries.AbstractTimeSeries;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.metadata.constants.NumericalConstants;

public class TimeSeriesStatistics
implements Serializable {
    private static final long serialVersionUID = 7214455207221523888L;
    private final AbstractTimeSeries _timeSeries;
    private boolean _isInvalid = false;
    private boolean _countMissingEnd = true;
    private boolean _countMissingStart = true;
    private int _numberValuesOkay = Integer.MIN_VALUE;
    private int _numberValuesMissing = Integer.MIN_VALUE;
    private int _numberValuesReject = Integer.MIN_VALUE;
    private int _numberValuesQuestion = Integer.MIN_VALUE;
    private int _numberValuesProtected = Integer.MIN_VALUE;
    private double _maxValue = -3.4028234663852886E38;
    private double _minValue = -3.4028234663852886E38;
    private double _absMinNonZeroValue = -3.4028234663852886E38;
    private double _aveValue = -3.4028234663852886E38;
    private long _maxValueTime = Long.MIN_VALUE;
    private long _minValueTime = Long.MIN_VALUE;

    TimeSeriesStatistics(AbstractTimeSeries timeSeries) {
        this._timeSeries = timeSeries;
    }

    private void updateStatistics() {
        this._numberValuesOkay = Integer.MIN_VALUE;
        this._numberValuesMissing = Integer.MIN_VALUE;
        this._numberValuesReject = Integer.MIN_VALUE;
        this._numberValuesQuestion = Integer.MIN_VALUE;
        this._numberValuesProtected = Integer.MIN_VALUE;
        this._maxValue = -3.4028234663852886E38;
        this._minValue = -3.4028234663852886E38;
        this._absMinNonZeroValue = -3.4028234663852886E38;
        this._aveValue = -3.4028234663852886E38;
        this._maxValueTime = Long.MIN_VALUE;
        this._minValueTime = Long.MIN_VALUE;
        double[] values = this._timeSeries.getValues();
        if (values != null && values.length > 0) {
            int i;
            this._isInvalid = true;
            long[] times = this._timeSeries.getTimes();
            this._maxValue = -1.7976931348623157E308;
            this._minValue = Double.MAX_VALUE;
            this._aveValue = -3.4028234663852886E38;
            this._absMinNonZeroValue = Double.MAX_VALUE;
            double sum = 0.0;
            this._numberValuesOkay = 0;
            this._numberValuesMissing = 0;
            this._numberValuesReject = 0;
            this._numberValuesQuestion = 0;
            this._numberValuesProtected = 0;
            int numberValuesProcessed = 0;
            Optional<Quality> quality = this._timeSeries.getQuality();
            for (i = 0; i < this._timeSeries.getNumberValues(); ++i) {
                double value = values[i];
                if (quality.isPresent() && quality.get().isProtected(i)) {
                    ++this._numberValuesProtected;
                }
                if (this._timeSeries.isMissing(i)) {
                    ++this._numberValuesMissing;
                }
                if (quality.isPresent() && quality.get().isQuestion(i)) {
                    ++this._numberValuesQuestion;
                }
                if (quality.isPresent() && quality.get().isReject(i)) {
                    ++this._numberValuesReject;
                }
                if (this._timeSeries.isOkay(i)) {
                    ++this._numberValuesOkay;
                }
                if (this.canProcessValue(i)) {
                    if (value > this._maxValue) {
                        this._maxValue = value;
                        this._maxValueTime = times[i];
                    }
                    if (value < this._minValue) {
                        this._minValue = value;
                        this._minValueTime = times[i];
                    }
                    sum += value;
                    ++numberValuesProcessed;
                }
                if (value == 0.0 || !NumericalConstants.isValidValue((double)value) || !(Math.abs(value) < this._absMinNonZeroValue)) continue;
                this._absMinNonZeroValue = value;
            }
            if (!this._countMissingEnd && this._numberValuesMissing > 0) {
                if (!quality.isPresent()) {
                    for (i = this._timeSeries.getNumberValues() - 1; i >= 0 && !NumericalConstants.isValidValue((double)this._timeSeries.getValues()[i]); --i) {
                        --this._numberValuesMissing;
                    }
                } else {
                    for (i = this._timeSeries.getNumberValues() - 1; i >= 0 && NumericalConstants.isNotValidValue((double)this._timeSeries.getValues()[i]) && quality.get().getIntegerAt(i) == 0 | (quality.get().isNotMissing(i) && quality.get().isNotProtected(i)); --i) {
                        --this._numberValuesMissing;
                    }
                }
            }
            if (!this._countMissingStart && this._numberValuesMissing > 0) {
                if (!quality.isPresent()) {
                    for (i = 0; i < this._timeSeries.getNumberValues() && NumericalConstants.isNotValidValue((double)this._timeSeries.getValues()[i]); ++i) {
                        --this._numberValuesMissing;
                    }
                } else {
                    for (i = 0; i < this._timeSeries.getNumberValues() && NumericalConstants.isNotValidValue((double)this._timeSeries.getValues()[i]) && quality.get().getIntegerAt(i) == 0 | (quality.get().isNotMissing(i) && quality.get().isNotProtected(i)); ++i) {
                        --this._numberValuesMissing;
                    }
                }
            }
            if (numberValuesProcessed > 0) {
                this._aveValue = sum / (double)numberValuesProcessed;
            }
        }
    }

    public final int getNumberValuesOkay() {
        if (!this._isInvalid) {
            this.updateStatistics();
        }
        return this._numberValuesOkay;
    }

    public final int getNumberValuesMissing() {
        if (!this._isInvalid) {
            this.updateStatistics();
        }
        return this._numberValuesMissing;
    }

    public final int getNumberValuesReject() {
        if (!this._isInvalid) {
            this.updateStatistics();
        }
        return this._numberValuesReject;
    }

    public final int getNumberValuesQuestion() {
        if (!this._isInvalid) {
            this.updateStatistics();
        }
        return this._numberValuesQuestion;
    }

    public final int getNumberValuesProtected() {
        if (!this._isInvalid) {
            this.updateStatistics();
        }
        return this._numberValuesProtected;
    }

    public final double getMaxValue() {
        if (!this._isInvalid) {
            this.updateStatistics();
        }
        return this._maxValue;
    }

    public final long getMaxValueTime() {
        if (!this._isInvalid) {
            this.updateStatistics();
        }
        return this._maxValueTime;
    }

    public final long getMinValueTime() {
        if (this._minValueTime == Long.MIN_VALUE) {
            this.updateStatistics();
        }
        return this._minValueTime;
    }

    public final double getMinValue() {
        if (!this._isInvalid) {
            this.updateStatistics();
        }
        return this._minValue;
    }

    public final double getAbsMinNonZeroValue() {
        if (!this._isInvalid) {
            this.updateStatistics();
        }
        return this._absMinNonZeroValue;
    }

    public final double getAveValue() {
        if (!this._isInvalid) {
            this.updateStatistics();
        }
        return this._aveValue;
    }

    public final void setCountMissing(boolean bStart, boolean bEnd) {
        this._countMissingEnd = bEnd;
        this._countMissingStart = bStart;
    }

    public void setOutOfDate() {
        this._isInvalid = false;
    }

    private boolean canProcessValue(int indexOfValue) {
        Optional<Quality> quality = this._timeSeries.getQuality();
        boolean valueIsNotMissing = !this._timeSeries.isMissing(indexOfValue);
        boolean valueIsNotRejected = quality.map(q -> q.isNotReject(indexOfValue)).orElse(true);
        return valueIsNotMissing && valueIsNotRejected;
    }
}

