/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import mil.army.usace.hec.data.timeseries.DataSetTimeSeriesDeriveException;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.TimeSeriesStatistics;
import mil.army.usace.hec.data.timeseries.VersionDate;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.DataSetException;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.Units;
import mil.army.usace.hec.metadata.UnitsConversionException;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.VerticalDatumException;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesException;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.IntervalOffsetMismatchException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;

class TimeSeriesWithVerticalDatum
implements VerticalDatum,
TimeSeries {
    private static final long serialVersionUID = -6750938518873006266L;
    private final TimeSeries _timeSeries;
    private final VerticalDatumContainer _verticalDatumContainer;

    TimeSeriesWithVerticalDatum(TimeSeries timeSeries, VerticalDatumContainer verticalDatumContainer) {
        this._timeSeries = timeSeries;
        this._verticalDatumContainer = verticalDatumContainer;
    }

    TimeSeries getTimeSeries() {
        return this._timeSeries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeSeriesWithVerticalDatum that = (TimeSeriesWithVerticalDatum)o;
        return Objects.equals(this.getTimeSeries(), that.getTimeSeries()) && Objects.equals(this.getVerticalDatumContainer(), that.getVerticalDatumContainer());
    }

    public int hashCode() {
        return Objects.hash(this.getTimeSeries(), this.getVerticalDatumContainer());
    }

    public String getNativeVerticalDatum() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this._verticalDatumContainer.getNativeVerticalDatum();
    }

    public String getCurrentVerticalDatum() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this._verticalDatumContainer.getCurrentVerticalDatum();
    }

    public boolean isCurrentVerticalDatumEstimated() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this._verticalDatumContainer.isCurrentVerticalDatumEstimated();
    }

    public boolean toNativeVerticalDatum() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        double offset = this._verticalDatumContainer.getCurrentOffset(this._timeSeries.getUnits().toString());
        boolean change = this._verticalDatumContainer.toNativeVerticalDatum();
        if (change) {
            this.applyOffset(offset);
        }
        return change;
    }

    private void applyOffset(double offset) throws VerticalDatumException {
        double[] values = Arrays.copyOf(this._timeSeries.getValues(), this._timeSeries.getNumberValues());
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == -3.4028234663852886E38) continue;
            int n = i;
            values[n] = values[n] - offset;
        }
        try {
            this._timeSeries.set(this._timeSeries.getTimes(), values, this._timeSeries.getQuality().orElse(null));
        }
        catch (DataSetIllegalArgumentException | DataSetTimeSeriesIllegalArgumentException | IntervalOffsetMismatchException e) {
            throw new VerticalDatumException("Unable to apply vertical datum offset to time series", e);
        }
    }

    public boolean toNGVD29() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        String unit = this._timeSeries.getUnits().toString();
        double offset = this._verticalDatumContainer.getNGVD29Offset(unit) - this._verticalDatumContainer.getCurrentOffset(unit);
        boolean change = this._verticalDatumContainer.toNGVD29();
        if (change) {
            this.applyOffset(offset);
        }
        return change;
    }

    public boolean toNAVD88() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        String unit = this._timeSeries.getUnits().toString();
        double offset = this._verticalDatumContainer.getNAVD88Offset(unit) - this._verticalDatumContainer.getCurrentOffset(unit);
        boolean change = this._verticalDatumContainer.toNAVD88();
        if (change) {
            this.applyOffset(offset);
        }
        return change;
    }

    public boolean toVerticalDatum(String datum) throws VerticalDatumException {
        if (datum == null) {
            throw new VerticalDatumException("Null datum specified");
        }
        double offset1 = this._verticalDatumContainer.getCurrentOffset();
        boolean change = this._verticalDatumContainer.toVerticalDatum(datum);
        if (change) {
            double offset2 = this._verticalDatumContainer.getCurrentOffset();
            this.applyOffset(offset2 - offset1);
        }
        return change;
    }

    public boolean forceVerticalDatum(String datum) throws VerticalDatumException {
        return this._verticalDatumContainer.forceVerticalDatum(datum);
    }

    public double getCurrentOffset() throws VerticalDatumException {
        return this.getCurrentOffset(this._timeSeries.getUnits().toString());
    }

    public double getCurrentOffset(String unit) throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this._verticalDatumContainer.getCurrentOffset(unit);
    }

    public double getNGVD29Offset() throws VerticalDatumException {
        return this.getNGVD29Offset(this._timeSeries.getUnits().toString());
    }

    public double getNGVD29Offset(String unit) throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this._verticalDatumContainer.getNGVD29Offset(unit);
    }

    public double getNAVD88Offset() throws VerticalDatumException {
        return this.getNAVD88Offset(this._timeSeries.getUnits().toString());
    }

    public double getNAVD88Offset(String unit) throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this._verticalDatumContainer.getNAVD88Offset(unit);
    }

    public boolean isNGVD29OffsetEstimated() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this._verticalDatumContainer.isNGVD29OffsetEstimated();
    }

    public boolean isNAVD88OffsetEstimated() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this._verticalDatumContainer.isNAVD88OffsetEstimated();
    }

    public String getVerticalDatumInfo() throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        return this._verticalDatumContainer.getVerticalDatumInfo();
    }

    public void setVerticalDatumInfo(String xmlStr) throws VerticalDatumException {
        this.checkVerticalDatumContainer();
        this._verticalDatumContainer.setVerticalDatumInfo(xmlStr);
    }

    private void checkParameter() throws VerticalDatumException {
        if (!"Elev".equals(this._timeSeries.getTimeSeriesIdentifier().getParameter().getBaseParameter())) {
            throw new VerticalDatumException("Parameter must be an elevation");
        }
    }

    private void checkVerticalDatumContainer() throws VerticalDatumException {
        if (this._verticalDatumContainer == null) {
            throw new VerticalDatumException("VerticalDatumContainer has not been initialized");
        }
        this.checkParameter();
    }

    @Override
    public TimeSeriesStatistics getTimeSeriesStatistics() {
        return this._timeSeries.getTimeSeriesStatistics();
    }

    @Override
    public void set(long[] times, double[] values, Quality quality) throws DataSetTimeSeriesIllegalArgumentException, IntervalOffsetMismatchException, DataSetIllegalArgumentException {
        this._timeSeries.set(times, values, quality);
    }

    @Override
    public NavigableMap<ZonedDateTime, Double> getData() {
        return this._timeSeries.getData();
    }

    @Override
    public NavigableMap<ZonedDateTime, Double> getData(ZoneId zoneId) {
        return this._timeSeries.getData(zoneId);
    }

    @Override
    public NavigableMap<Date, Double> getDateValueNavigableMap() {
        return this._timeSeries.getDateValueNavigableMap();
    }

    @Override
    public double[] getValues() {
        return this._timeSeries.getValues();
    }

    @Override
    public void trim() throws DataSetTimeSeriesIllegalArgumentException {
        this._timeSeries.trim();
    }

    @Override
    public double[] getValuesWithQualityFlagsApplied() {
        return this._timeSeries.getValuesWithQualityFlagsApplied();
    }

    @Override
    public int getIndexOfLatestValidValue() {
        return this._timeSeries.getIndexOfLatestValidValue();
    }

    @Override
    public Optional<VersionDate> getVersionDate() {
        return this._timeSeries.getVersionDate();
    }

    @Override
    public Optional<Quality> getQuality() {
        return this._timeSeries.getQuality();
    }

    @Override
    public boolean hasQuality() {
        return this._timeSeries.hasQuality();
    }

    @Override
    public void addEmptyQualityTx() {
        this._timeSeries.addEmptyQualityTx();
    }

    @Override
    public long[] getTimes() {
        return this._timeSeries.getTimes();
    }

    @Override
    public NavigableSet<Instant> getInstants() {
        return this._timeSeries.getInstants();
    }

    @Override
    public boolean isOkay(int index) {
        return this._timeSeries.isOkay(index);
    }

    @Override
    public boolean isMissing(int index) {
        return this._timeSeries.isMissing(index);
    }

    @Override
    public int getNumberValues() {
        return this._timeSeries.getNumberValues();
    }

    @Override
    public boolean isSameTimeWindow(TimeSeries timeSeries) {
        return this._timeSeries.isSameTimeWindow(timeSeries);
    }

    @Override
    public boolean needToChangeUnits(Units units) throws DataSetTimeSeriesDeriveException {
        return this._timeSeries.needToChangeUnits(units);
    }

    @Override
    public void changeUnits(Units toUnits) throws DataSetTimeSeriesDeriveException {
        this._timeSeries.changeUnits(toUnits);
    }

    @Override
    public void changeUnitSystem(String unitSystem) throws UnitsConversionException, DataSetIllegalArgumentException, DataSetTimeSeriesException {
        this._timeSeries.changeUnitSystem(unitSystem);
    }

    @Override
    public void changeUnitSystem(int unitSystemId) throws DataSetTimeSeriesException, UnitsConversionException, DataSetIllegalArgumentException {
        this._timeSeries.changeUnitSystem(unitSystemId);
    }

    @Override
    public void window(TimeSeriesTemplate timeSeriesTemplate) throws DataSetTimeSeriesDeriveException {
        this._timeSeries.window(timeSeriesTemplate);
    }

    @Override
    public void fillTails(TimeSeriesTemplate template) throws DataSetTimeSeriesException, DataSetIllegalArgumentException {
        this._timeSeries.fillTails(template);
    }

    @Override
    public void trimTail() {
        this._timeSeries.trimTail();
    }

    @Override
    public void removeRejectedAndMissingValues(boolean preserveRejectedAndMissingValues) throws DataSetTimeSeriesException, DataSetIllegalArgumentException, IntervalOffsetMismatchException {
        this._timeSeries.removeRejectedAndMissingValues(preserveRejectedAndMissingValues);
    }

    @Override
    public TimeSeries generateDifferences(TimeSeries filterData) throws DataSetException {
        return this._timeSeries.generateDifferences(filterData);
    }

    @Override
    public ZonedDateTime getStartTime() {
        return this._timeSeries.getStartTime();
    }

    @Override
    public ZonedDateTime getEndTime() {
        return this._timeSeries.getEndTime();
    }

    @Override
    public boolean getPreserveRejectedAndMissingValues() {
        return this._timeSeries.getPreserveRejectedAndMissingValues();
    }

    @Override
    public void setPreserveRejectedAndMissingValues(boolean preserveRejectedAndMissingValues) {
        this._timeSeries.setPreserveRejectedAndMissingValues(preserveRejectedAndMissingValues);
    }

    @Override
    public void setMaxTimeGap(long maxTimeGap) {
        this._timeSeries.setMaxTimeGap(maxTimeGap);
    }

    @Override
    public long getMaxTimeGap() {
        return this._timeSeries.getMaxTimeGap();
    }

    @Override
    public Optional<VerticalDatum> getVerticalDatum() {
        return Optional.of(this);
    }

    @Override
    public TimeSeriesIdentifier getTimeSeriesIdentifier() {
        return this._timeSeries.getTimeSeriesIdentifier();
    }

    @Override
    public Units getUnits() {
        return this._timeSeries.getUnits();
    }

    @Override
    public void setUnits(Units units) {
        this._timeSeries.setUnits(units);
    }

    public VerticalDatumContainer getVerticalDatumContainer() {
        return this._verticalDatumContainer;
    }

    @Override
    public boolean isEmpty() {
        return this._timeSeries.isEmpty();
    }

    public String toString() {
        return this._timeSeries.toString();
    }
}

