/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import mil.army.usace.hec.data.timeseries.VersionDate;
import mil.army.usace.hec.metadata.constants.NumericalConstants;

public final class VersionDateFormatter {
    private static final String AGGREGATE_VERSION = "Aggregate";
    private static final String BASE_DATE = "Base Date";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    private VersionDateFormatter() {
        throw new AssertionError((Object)"Utility class");
    }

    public static String format(VersionDate versionDate, ZoneId zoneId) {
        return versionDate.getVersionDate().map(v -> VersionDateFormatter.formatInstant(v, zoneId)).orElse(AGGREGATE_VERSION);
    }

    private static String formatInstant(Instant instant, ZoneId zoneId) {
        String name = BASE_DATE;
        if (!NumericalConstants.isNotVersioned((Instant)instant)) {
            name = FORMATTER.withZone(zoneId).format(instant);
        }
        return name;
    }
}

