/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries.adapter;

import java.time.Instant;
import java.time.ZoneId;
import java.util.NavigableSet;
import java.util.Optional;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.VersionDate;
import mil.army.usace.hec.data.timeseries.adapter.TimeSeriesDataAdapter;
import mil.army.usace.hec.metadata.Duration;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.LocationID;
import mil.army.usace.hec.metadata.OfficeId;
import mil.army.usace.hec.metadata.Parameter;
import mil.army.usace.hec.metadata.ParameterType;
import mil.army.usace.hec.metadata.Units;
import mil.army.usace.hec.metadata.Version;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.constants.NumericalConstants;

public final class TimeSeriesAdapter
implements TimeSeriesDataAdapter {
    private final TimeSeries _timeSeries;

    public TimeSeriesAdapter(TimeSeries timeSeries) {
        this._timeSeries = timeSeries;
    }

    @Override
    public String getIdentifier() {
        return this._timeSeries.getTimeSeriesIdentifier().getTimeSeriesId();
    }

    @Override
    public Optional<OfficeId> getOfficeId() {
        return this._timeSeries.getTimeSeriesIdentifier().getOfficeId();
    }

    @Override
    public NavigableSet<Instant> getInstants() {
        return this._timeSeries.getInstants();
    }

    @Override
    public double[] getValues() {
        return this._timeSeries.getValues();
    }

    @Override
    public Optional<Quality> getQuality() {
        return this._timeSeries.getQuality();
    }

    @Override
    public Units getUnits() {
        return this._timeSeries.getUnits();
    }

    @Override
    public Parameter getParameter() {
        return this._timeSeries.getTimeSeriesIdentifier().getParameter();
    }

    @Override
    public ParameterType getParameterType() {
        return this._timeSeries.getTimeSeriesIdentifier().getParameterType();
    }

    @Override
    public Interval getInterval() {
        return this._timeSeries.getTimeSeriesIdentifier().getInterval();
    }

    @Override
    public Optional<VerticalDatum> getVerticalDatum() {
        return this._timeSeries.getVerticalDatum();
    }

    @Override
    public LocationID getLocationId() {
        return this._timeSeries.getTimeSeriesIdentifier().getLocationId();
    }

    @Override
    public Duration getDuration() {
        return this._timeSeries.getTimeSeriesIdentifier().getDuration();
    }

    @Override
    public Version getVersion() {
        return this._timeSeries.getTimeSeriesIdentifier().getVersion();
    }

    @Override
    public ZoneId getDataZoneId() {
        return this._timeSeries.getTimeSeriesIdentifier().getIntervalZoneId().orElse(NumericalConstants.UTC_ZONEID);
    }

    @Override
    public Optional<VersionDate> getVersionDate() {
        return this._timeSeries.getVersionDate();
    }
}

