/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries.adapter;

import java.time.Instant;
import java.time.ZoneId;
import java.util.NavigableSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.TimeSeriesBuilder;
import mil.army.usace.hec.data.timeseries.VersionDate;
import mil.army.usace.hec.data.timeseries.adapter.TimeSeriesDataAdapter;
import mil.army.usace.hec.data.timeseries.adapter.TimeSeriesDataConverter;
import mil.army.usace.hec.metadata.DataSetException;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.Duration;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalOffset;
import mil.army.usace.hec.metadata.LocationID;
import mil.army.usace.hec.metadata.OfficeId;
import mil.army.usace.hec.metadata.Parameter;
import mil.army.usace.hec.metadata.ParameterType;
import mil.army.usace.hec.metadata.Version;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifierFactory;
import rma.services.annotations.ServiceProvider;

@ServiceProvider(service=TimeSeriesDataConverter.class, position=100)
public final class TimeSeriesConverter
implements TimeSeriesDataConverter<TimeSeries> {
    private static final Logger LOGGER = Logger.getLogger(TimeSeriesConverter.class.getName());

    @Override
    public boolean canConvertTo(Class<?> destinationType) {
        return destinationType.isAssignableFrom(TimeSeries.class);
    }

    @Override
    public TimeSeries convert(TimeSeriesDataAdapter adapter) throws DataSetTimeSeriesIllegalArgumentException {
        try {
            TimeSeriesIdentifier timeSeriesIdentifier = TimeSeriesConverter.extractIdentifier(adapter);
            Quality quality = adapter.getQuality().map(Quality::new).orElse(null);
            VerticalDatumContainer vdc = adapter.getVerticalDatum().map(VerticalDatum::getVerticalDatumContainer).orElse(null);
            VersionDate versionDate = adapter.getVersionDate().orElse(null);
            NavigableSet<Instant> instants = adapter.getInstants();
            long[] times = instants.isEmpty() ? new long[]{} : (timeSeriesIdentifier.getInterval().isIrregular() ? instants.stream().mapToLong(Instant::toEpochMilli).toArray() : new long[]{((Instant)instants.first()).toEpochMilli()});
            double[] values = adapter.getValues();
            return TimeSeriesBuilder.createBuilder(timeSeriesIdentifier, adapter.getUnits()).withTimes(times).withValues(values).withQuality(quality).withVerticalDatum(vdc).withVersionDate(versionDate).build();
        }
        catch (DataSetException e) {
            throw new DataSetTimeSeriesIllegalArgumentException((Throwable)e);
        }
    }

    private static TimeSeriesIdentifier extractIdentifier(TimeSeriesDataAdapter adapter) throws DataSetIllegalArgumentException {
        TimeSeriesIdentifier timeSeriesIdentifier;
        try {
            timeSeriesIdentifier = TimeSeriesConverter.extractFromId(adapter);
        }
        catch (DataSetIllegalArgumentException e) {
            LOGGER.log(Level.FINE, e, () -> "Could not extract TimeSeriesIdentifier from id: " + adapter.getIdentifier() + " extracting from parts");
            timeSeriesIdentifier = TimeSeriesConverter.extractFromParts(adapter);
        }
        return timeSeriesIdentifier;
    }

    private static TimeSeriesIdentifier extractFromParts(TimeSeriesDataAdapter adapter) throws DataSetIllegalArgumentException {
        OfficeId officeId = adapter.getOfficeId().map(OfficeId::new).orElse(null);
        LocationID locationId = adapter.getLocationId();
        Parameter parameter = adapter.getParameter();
        ParameterType parameterType = adapter.getParameterType();
        Interval interval = adapter.getInterval();
        Duration duration = adapter.getDuration();
        Version version = adapter.getVersion();
        return TimeSeriesIdentifierFactory.from((OfficeId)officeId, (LocationID)locationId, (Parameter)parameter, (ParameterType)parameterType, (Interval)interval, (Duration)duration, (Version)version);
    }

    private static TimeSeriesIdentifier extractFromId(TimeSeriesDataAdapter adapter) throws DataSetIllegalArgumentException {
        OfficeId officeId = adapter.getOfficeId().map(OfficeId::new).orElse(null);
        ZoneId zoneId = adapter.getLocationId().getZoneId().orElse(NumericalConstants.UTC_ZONEID);
        IntervalOffset intervalOffset = IntervalOffset.undefinedOffset();
        if (adapter.getInterval().isIrregular()) {
            intervalOffset = IntervalOffset.noOffset();
        }
        return TimeSeriesIdentifierFactory.from((OfficeId)officeId, (String)adapter.getIdentifier(), (IntervalOffset)intervalOffset, (ZoneId)zoneId);
    }
}

