/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries.adapter;

import java.io.Serializable;
import java.util.Objects;
import mil.army.usace.hec.data.timeseries.adapter.TimeSeriesDataAdapter;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesException;
import rma.util.lookup.Lookup;

public interface TimeSeriesDataConverter<T extends Serializable> {
    public static <T extends Serializable> T convert(TimeSeriesDataAdapter adapter, Class<T> destinationType) throws DataSetTimeSeriesException {
        Objects.requireNonNull(adapter, "Cannot convert a null time series source");
        Objects.requireNonNull(destinationType, "Cannot convert to a null time series destination type");
        TimeSeriesDataConverter timeSeriesConverter = Lookup.getDefault().lookupAll(TimeSeriesDataConverter.class).stream().filter(s -> s.canConvertTo(destinationType)).findFirst().orElseThrow(() -> new DataSetTimeSeriesException("Cannot convert time series adapter: " + adapter + " to " + destinationType));
        return timeSeriesConverter.convert(adapter);
    }

    public boolean canConvertTo(Class<?> var1);

    public T convert(TimeSeriesDataAdapter var1) throws DataSetTimeSeriesException;
}

