/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries.comparator;

import java.util.Comparator;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.comparator.TimeSeriesComparator;

public class TimeSeriesQualityComparator
implements Comparator<TimeSeries> {
    @Override
    public int compare(TimeSeries ds1, TimeSeries ds2) {
        byte[] quality2;
        Quality qualityTx2;
        int nullCompareTimeSeries = TimeSeriesComparator.nullCompare(ds1, ds2);
        if (nullCompareTimeSeries != Integer.MIN_VALUE) {
            return nullCompareTimeSeries;
        }
        Quality qualityTx1 = ds1.getQuality().orElse(null);
        int nullCompareQuality = TimeSeriesComparator.nullCompare(qualityTx1, qualityTx2 = (Quality)ds2.getQuality().orElse(null));
        if (nullCompareQuality != Integer.MIN_VALUE) {
            return nullCompareQuality;
        }
        if (qualityTx1 == null) {
            return -1;
        }
        if (qualityTx2 == null) {
            return 1;
        }
        byte[] quality1 = qualityTx1.getQuality();
        int nullCompareBytes = TimeSeriesComparator.nullCompare(quality1, quality2 = qualityTx2.getQuality());
        if (nullCompareBytes != Integer.MIN_VALUE) {
            return nullCompareBytes;
        }
        if (quality1.length != quality2.length) {
            return Integer.compare(quality1.length, quality2.length);
        }
        return this.compareQualityArrays(quality1, quality2);
    }

    private int compareQualityArrays(byte[] quality1, byte[] quality2) {
        int retVal = 0;
        for (int i = 0; i < quality1.length; ++i) {
            int comp = Byte.compare(quality1[i], quality2[i]);
            if (comp == 0) continue;
            retVal = comp;
            break;
        }
        return retVal;
    }
}

