/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries.comparator;

import java.util.Comparator;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.comparator.TimeSeriesComparator;
import mil.army.usace.hec.metadata.constants.NumericalConstants;

public class TimeSeriesValuesComparator
implements Comparator<TimeSeries> {
    private final double _epsilon;

    public TimeSeriesValuesComparator(double epsilon) {
        this._epsilon = epsilon;
    }

    public TimeSeriesValuesComparator() {
        this._epsilon = 1.0E-6;
    }

    @Override
    public int compare(TimeSeries ds1, TimeSeries ds2) {
        double[] ds2Values;
        if (TimeSeriesComparator.nullCompare(ds1, ds2) != Integer.MIN_VALUE) {
            return TimeSeriesComparator.nullCompare(ds1, ds2);
        }
        double[] ds1Values = ds1.getValues();
        if (TimeSeriesComparator.nullCompare(ds1Values, ds2Values = ds2.getValues()) != Integer.MIN_VALUE) {
            return TimeSeriesComparator.nullCompare(ds1Values, ds2Values);
        }
        if (ds1Values.length != ds2Values.length) {
            return Integer.compare(ds1Values.length, ds2Values.length);
        }
        return this.compareValueArrays(ds1Values, ds2Values);
    }

    private int compareValueArrays(double[] ds1Values, double[] ds2Values) {
        int retVal = 0;
        for (int i = 0; i < ds1Values.length; ++i) {
            int comp = NumericalConstants.compareTo((double)ds1Values[i], (double)ds2Values[i], (double)this._epsilon);
            if (comp == 0) continue;
            retVal = comp;
            break;
        }
        return retVal;
    }
}

