/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries.math;

import java.util.Arrays;

public enum TimeComparisonMethod {
    COMPARE_NORMAL_TIMES(0, "COMPARE_NORMAL_TIMES"),
    COMPARE_TRUNCATED_TIMES(1, "COMPARE_TRUNCATED_TIMES"),
    COMPARE_ROUNDED_TIMES(2, "COMPARE_ROUNDED_TIMES"),
    COMPARE_NEAR_TIMES(3, "COMPARE_NEAR_TIMES");

    private final int _value;
    private final String _name;

    private TimeComparisonMethod(int value, String name) {
        this._value = value;
        this._name = name;
    }

    public String toString() {
        return this._name;
    }

    public int getValue() {
        return this._value;
    }

    public TimeComparisonMethod methodForValue(int value) {
        return Arrays.stream(TimeComparisonMethod.values()).filter(i -> i._value == value).findAny().orElseThrow(() -> new IllegalArgumentException("Cannot determine time comparison method"));
    }
}

