/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries.math;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.data.timeseries.DataSetTimeSeriesCombineException;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.TimeSeriesFactory;
import mil.army.usace.hec.data.timeseries.math.TimeComparisonMethod;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.DataSetException;
import mil.army.usace.hec.metadata.IntervalOffset;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.VerticalDatumException;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import mil.army.usace.hec.metadata.constants.TimeSeriesStoreRule;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifierBuilder;

public final class TimeSeriesCombine {
    private static final Logger LOGGER = Logger.getLogger(TimeSeriesCombine.class.getName());
    private final TimeSeriesStoreRule _storeRule;
    private final boolean _overrideProtection;
    private final long _timeComparisonInterval;
    private final TimeComparisonMethod _timeComparisonMethod;

    private TimeSeriesCombine(TimeSeriesStoreRule storeRule, boolean overrideProtection, long timeComparisonInterval, TimeComparisonMethod timeComparisonMethod) throws DataSetTimeSeriesCombineException {
        if (timeComparisonInterval < 0L) {
            throw new DataSetTimeSeriesCombineException("Cannot combine:\nTime comparison interval (" + timeComparisonInterval + ") must be non-negative.\n");
        }
        this._storeRule = storeRule;
        this._overrideProtection = overrideProtection;
        this._timeComparisonInterval = timeComparisonInterval;
        this._timeComparisonMethod = timeComparisonMethod;
    }

    public static TimeSeries combine(TimeSeries original, TimeSeries combine, TimeSeriesStoreRule storeRule, boolean overrideProtection, long timeComparisonInterval, TimeComparisonMethod timeComparisonMethod) throws DataSetException {
        return new TimeSeriesCombine(storeRule, overrideProtection, timeComparisonInterval, timeComparisonMethod).combine(original, combine);
    }

    public static TimeSeries combine(TimeSeries original, TimeSeries combine, TimeSeriesStoreRule storeRule, boolean overrideProtection) throws DataSetException {
        return new TimeSeriesCombine(storeRule, overrideProtection, 0L, TimeComparisonMethod.COMPARE_NORMAL_TIMES).combine(original, combine);
    }

    public static boolean cannotCombine(TimeSeries original, TimeSeriesTemplate combine) {
        return !TimeSeriesCombine.canCombine(original, combine);
    }

    public static boolean canCombine(TimeSeries original, TimeSeriesTemplate combine) {
        TimeSeriesIdentifier originalIdentifier = original.getTimeSeriesIdentifier();
        TimeSeriesIdentifier combineIdentifier = combine.getTimeSeriesIdentifier();
        return original.getUnits().equals((Object)combine.getUnits()) && originalIdentifier.getParameter().getBaseParameter().equalsIgnoreCase(combineIdentifier.getParameter().getBaseParameter()) && originalIdentifier.getParameterType().equals((Object)combineIdentifier.getParameterType()) && originalIdentifier.getInterval().equals(combineIdentifier.getInterval()) && originalIdentifier.getDuration().equals((Object)combineIdentifier.getDuration()) && originalIdentifier.getIntervalOffset().equals((Object)combineIdentifier.getIntervalOffset());
    }

    public static TimeSeries combine(TimeSeries original, long time, double value, byte[] qualityBytes, TimeSeriesStoreRule storeRule, boolean overrideProtection, long timeComparisonInterval, TimeComparisonMethod timeComparisonMethod) throws DataSetException {
        TimeSeriesIdentifier timeSeriesIdentifier;
        Quality quality = null;
        if (qualityBytes != null) {
            quality = new Quality(qualityBytes);
        }
        IntervalOffset clearedOffset = (timeSeriesIdentifier = original.getTimeSeriesIdentifier()).getInterval().isIrregular() ? IntervalOffset.noOffset() : IntervalOffset.undefinedOffset();
        TimeSeriesIdentifier newTimeSeriesIdentifier = new TimeSeriesIdentifierBuilder(timeSeriesIdentifier).withIntervalOffset(clearedOffset).build();
        TimeSeriesTemplate timeSeriesTemplate = new TimeSeriesTemplate(newTimeSeriesIdentifier, original.getUnits());
        Optional<VerticalDatumContainer> verticalDatumContainer = original.getVerticalDatum().map(VerticalDatum::getVerticalDatumContainer);
        TimeSeries combine = verticalDatumContainer.isPresent() ? TimeSeriesFactory.buildTimeSeries(timeSeriesTemplate, new long[]{time}, new double[]{value}, quality, verticalDatumContainer.get()) : TimeSeriesFactory.buildTimeSeries(timeSeriesTemplate, new long[]{time}, new double[]{value}, quality);
        return TimeSeriesCombine.combine(original, combine, storeRule, overrideProtection, timeComparisonInterval, timeComparisonMethod);
    }

    private boolean isSameTime(long time1, long time2) throws DataSetTimeSeriesIllegalArgumentException {
        boolean result;
        switch (this._timeComparisonMethod) {
            case COMPARE_NORMAL_TIMES: {
                result = time1 == time2;
                break;
            }
            case COMPARE_TRUNCATED_TIMES: {
                time1 -= time1 % this._timeComparisonInterval;
                time2 -= time2 % this._timeComparisonInterval;
                result = time1 == time2;
                break;
            }
            case COMPARE_ROUNDED_TIMES: {
                time1 += this._timeComparisonInterval / 2L;
                time1 -= time1 % this._timeComparisonInterval;
                time2 += this._timeComparisonInterval / 2L;
                time2 -= time2 % this._timeComparisonInterval;
                result = time1 == time2;
                break;
            }
            case COMPARE_NEAR_TIMES: {
                result = Math.abs(time2 - time1) <= this._timeComparisonInterval;
                break;
            }
            default: {
                throw new DataSetTimeSeriesIllegalArgumentException("\nisSameTime() : Time comparison method (" + this._timeComparisonMethod + ") is invalid.\n");
            }
        }
        return result;
    }

    public TimeSeries combine(TimeSeries original, TimeSeries combine) throws DataSetException {
        if (TimeSeriesCombine.cannotCombine(original, combine)) {
            throw new DataSetTimeSeriesCombineException("Cannot combine:\n" + original.toString() + "\nWith:\n" + combine.toString());
        }
        TimeSeries retval = this.combineValues(original, combine);
        if (!original.getPreserveRejectedAndMissingValues() || !combine.getPreserveRejectedAndMissingValues()) {
            retval.removeRejectedAndMissingValues(false);
        }
        return retval;
    }

    private TimeSeries combineValues(TimeSeries original, TimeSeries combine) throws DataSetException {
        Optional<VerticalDatumContainer> verticalDatum;
        IntervalOffset intervalOffset = original.getTimeSeriesIdentifier().getIntervalOffset();
        IntervalOffset dataSetIntervalOffset = combine.getTimeSeriesIdentifier().getIntervalOffset();
        if (intervalOffset.isDefined() && !this.isSameTime(intervalOffset.getOffsetMillis(), dataSetIntervalOffset.getOffsetMillis()) && !original.isEmpty() && !combine.isEmpty()) {
            throw new DataSetTimeSeriesCombineException("Cannot combine:\n" + original.toString() + "\n Interval Offset From UTC: " + intervalOffset + " Seconds\nWith:\n" + combine.toString() + "\nInterval Offset From UTC: " + dataSetIntervalOffset + " Seconds\nTime Comparison Method : " + this._timeComparisonMethod + " (" + this._timeComparisonInterval + " milliseconds)\n");
        }
        TimeSeries retval = combine.isEmpty() ? TimeSeriesFactory.copy(original) : (original.isEmpty() ? ((verticalDatum = combine.getVerticalDatum().map(v -> {
            if (v instanceof VerticalDatumContainer) {
                return (VerticalDatumContainer)v;
            }
            return null;
        })).isPresent() ? TimeSeriesFactory.buildTimeSeries(new TimeSeriesTemplate(original.getTimeSeriesIdentifier(), original.getUnits()), combine.getTimes(), combine.getValues(), (Quality)combine.getQuality().orElse(null), verticalDatum.get()) : TimeSeriesFactory.buildTimeSeries(new TimeSeriesTemplate(original.getTimeSeriesIdentifier(), original.getUnits()), combine.getTimes(), combine.getValues(), (Quality)combine.getQuality().orElse(null))) : this.combineValuesAndQuality(original, combine));
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimeSeries combineValuesAndQuality(TimeSeries original, TimeSeries combine) throws DataSetException {
        String originalCurrentVerticalDatum = this.getCurrentVerticalDatum(original);
        String combineCurrentVerticalDatum = this.getCurrentVerticalDatum(combine);
        boolean verticalDatumsDifferent = TimeSeriesCombine.areVerticalDatumsDifferent(originalCurrentVerticalDatum, combineCurrentVerticalDatum);
        try {
            if (verticalDatumsDifferent) {
                this.toNativeVerticalDatum(original);
                this.toNativeVerticalDatum(combine);
            }
            ZoneId originalZoneId = (ZoneId)original.getTimeSeriesIdentifier().getIntervalZoneId().orElseThrow(() -> new DataSetTimeSeriesIllegalArgumentException("Unable to combine time series without a time zone"));
            ZoneId combineZoneId = (ZoneId)combine.getTimeSeriesIdentifier().getIntervalZoneId().orElseThrow(() -> new DataSetTimeSeriesIllegalArgumentException("Unable to combine time series without a time zone"));
            NavigableMap<ZonedDateTime, Double> originalValues = original.getData();
            NavigableMap originalQuality = original.getQuality().map(q -> q.getQualityIntegers(original.getTimes(), originalZoneId)).orElse(new TreeMap());
            NavigableMap<ZonedDateTime, Double> combineValues = this.normalizeTimes(originalValues, combine.getData());
            NavigableMap combineQuality = this.normalizeTimes(originalQuality, combine.getQuality().map(q -> q.getQualityIntegers(combine.getTimes(), combineZoneId)).orElse(new TreeMap()));
            TreeMap<ZonedDateTime, Double> newValues = new TreeMap<ZonedDateTime, Double>((SortedMap<ZonedDateTime, Double>)originalValues);
            TreeMap<ZonedDateTime, Integer> newQuality = new TreeMap<ZonedDateTime, Integer>(originalQuality);
            if (this._storeRule == TimeSeriesStoreRule.DELETE_INSERT && !combineValues.isEmpty()) {
                ZonedDateTime start = (ZonedDateTime)combineValues.firstKey();
                ZonedDateTime end = (ZonedDateTime)combineValues.lastKey();
                newValues.entrySet().removeIf(e -> this.inTimeWindowInclusive((ZonedDateTime)e.getKey(), start, end) && (this._overrideProtection || !this.isProtected((Integer)originalQuality.get(e.getKey()))));
                newQuality.entrySet().removeIf(e -> this.inTimeWindowInclusive((ZonedDateTime)e.getKey(), start, end) && (this._overrideProtection || !this.isProtected((Integer)e.getValue())));
            }
            combineValues.forEach((combineTime, combineValue) -> newValues.merge((ZonedDateTime)combineTime, (Double)combineValue, (ov, cv) -> {
                boolean originalProtected = this.isProtected(originalQuality.getOrDefault(combineTime, Quality.emptyQualityValue()));
                boolean combinedProtected = this.isProtected(combineQuality.getOrDefault(combineTime, Quality.emptyQualityValue()));
                boolean originalMissing = this.isMissing(originalQuality.getOrDefault(combineTime, Quality.emptyQualityValue()), (Double)ov);
                boolean combinedMissing = this.isMissing(combineQuality.getOrDefault(combineTime, Quality.emptyQualityValue()), (Double)cv);
                if (!originalProtected || combinedProtected || this._overrideProtection) {
                    return this.mergeValueSameTime((Double)ov, (Double)cv, originalMissing, combinedMissing);
                }
                return ov;
            }));
            combineQuality.forEach((combineTime, combineQualityValue) -> newQuality.merge((ZonedDateTime)combineTime, (Integer)combineQualityValue, (ov, cv) -> {
                boolean originalProtected = this.isProtected(originalQuality.getOrDefault(combineTime, Quality.emptyQualityValue()));
                boolean combinedProtected = this.isProtected(combineQuality.getOrDefault(combineTime, Quality.emptyQualityValue()));
                Double originalValue = (Double)originalValues.get(combineTime);
                Double combineValue = (Double)combineValues.get(combineTime);
                boolean originalMissing = this.isMissing(originalQuality.getOrDefault(combineTime, Quality.emptyQualityValue()), originalValue);
                boolean combinedMissing = this.isMissing(combineQuality.getOrDefault(combineTime, Quality.emptyQualityValue()), combineValue);
                if (!originalProtected || combinedProtected || this._overrideProtection) {
                    return this.mergeQualitySameTime((Integer)ov, (Integer)cv, originalMissing, combinedMissing, NumericalConstants.isValidValue((Double)originalValue), NumericalConstants.isValidValue((Double)combineValue));
                }
                return ov;
            }));
            TimeSeries timeSeries = this.buildNewTimeSeries(original, newValues, newQuality);
            try {
                this.resetVerticalDatum(timeSeries, originalCurrentVerticalDatum);
            }
            catch (DataSetTimeSeriesCombineException e2) {
                LOGGER.log(Level.FINE, (Throwable)((Object)e2), () -> "Unable to convert vertical datum back into the original datum: " + originalCurrentVerticalDatum + " for combined time series:" + timeSeries);
            }
            TimeSeries timeSeries2 = timeSeries;
            return timeSeries2;
        }
        finally {
            if (verticalDatumsDifferent) {
                this.resetVerticalDatum(original, originalCurrentVerticalDatum);
                this.resetVerticalDatum(combine, combineCurrentVerticalDatum);
            }
        }
    }

    private boolean inTimeWindowInclusive(ZonedDateTime check, ZonedDateTime start, ZonedDateTime end) {
        return check.equals(start) || check.equals(end) || check.isBefore(end) && check.isAfter(start);
    }

    private TimeSeries buildNewTimeSeries(TimeSeries original, NavigableMap<ZonedDateTime, Double> combinedValues, NavigableMap<ZonedDateTime, Integer> combinedQuality) throws DataSetException {
        TimeSeries retval;
        long[] times = combinedValues.keySet().stream().map(ChronoZonedDateTime::toInstant).mapToLong(Instant::toEpochMilli).toArray();
        double[] values = combinedValues.values().stream().mapToDouble(value -> value).toArray();
        if (!combinedQuality.isEmpty()) {
            combinedValues.keySet().forEach(z -> combinedQuality.putIfAbsent((ZonedDateTime)z, Quality.emptyQualityValue()));
        }
        int[] quality = combinedQuality.values().stream().mapToInt(i -> i).toArray();
        TimeSeriesTemplate timeSeriesTemplate = new TimeSeriesTemplate(original.getTimeSeriesIdentifier(), original.getStartTime().toInstant().toEpochMilli(), original.getEndTime().toInstant().toEpochMilli(), original.getUnits(), original.getPreserveRejectedAndMissingValues(), original.getMaxTimeGap());
        if (times.length == 0) {
            timeSeriesTemplate.clearTimeWindow();
            Optional<VerticalDatumContainer> verticalDatumContainer = original.getVerticalDatum().map(VerticalDatum::getVerticalDatumContainer);
            retval = verticalDatumContainer.isPresent() ? TimeSeriesFactory.buildTimeSeries(timeSeriesTemplate, verticalDatumContainer.get()) : TimeSeriesFactory.buildTimeSeries(timeSeriesTemplate);
            if (quality.length > 0) {
                retval.addEmptyQualityTx();
            }
        } else {
            Quality newQuality = null;
            if (quality.length > 0) {
                newQuality = new Quality(quality);
            }
            timeSeriesTemplate.setStartTime(times[0]);
            timeSeriesTemplate.setEndTime(times[times.length - 1]);
            Optional<VerticalDatumContainer> verticalDatumContainer = original.getVerticalDatum().map(VerticalDatum::getVerticalDatumContainer);
            retval = verticalDatumContainer.isPresent() ? TimeSeriesFactory.buildTimeSeries(timeSeriesTemplate, times, values, newQuality, verticalDatumContainer.get()) : TimeSeriesFactory.buildTimeSeries(timeSeriesTemplate, times, values, newQuality);
        }
        return retval;
    }

    private <T> NavigableMap<ZonedDateTime, T> normalizeTimes(NavigableMap<ZonedDateTime, T> originalValues, NavigableMap<ZonedDateTime, T> combineValues) throws DataSetTimeSeriesIllegalArgumentException {
        TreeMap retval = new TreeMap();
        for (Map.Entry combineEntry : combineValues.entrySet()) {
            ZonedDateTime floor = originalValues.floorKey((ZonedDateTime)combineEntry.getKey());
            ZonedDateTime ceiling = originalValues.ceilingKey((ZonedDateTime)combineEntry.getKey());
            if (floor != null && this.isSameTime(((ZonedDateTime)combineEntry.getKey()).toInstant().toEpochMilli(), floor.toInstant().toEpochMilli())) {
                retval.put(floor, combineEntry.getValue());
                continue;
            }
            if (ceiling != null && this.isSameTime(((ZonedDateTime)combineEntry.getKey()).toInstant().toEpochMilli(), ceiling.toInstant().toEpochMilli())) {
                retval.put(ceiling, combineEntry.getValue());
                continue;
            }
            retval.put((ZonedDateTime)combineEntry.getKey(), combineEntry.getValue());
        }
        return retval;
    }

    private void toNativeVerticalDatum(TimeSeries timeSeries) {
        Optional<VerticalDatum> verticalDatum = timeSeries.getVerticalDatum();
        if (verticalDatum.isPresent()) {
            try {
                verticalDatum.get().toNativeVerticalDatum();
            }
            catch (VerticalDatumException e) {
                LOGGER.log(Level.FINER, e, () -> "No vertical datum information in time series, cannot convert to native datum: " + timeSeries.getTimeSeriesIdentifier());
            }
        }
    }

    private String getCurrentVerticalDatum(TimeSeries timeSeries) {
        Optional<VerticalDatum> verticalDatum = timeSeries.getVerticalDatum();
        String currentVerticalDatum = null;
        if (verticalDatum.isPresent()) {
            try {
                currentVerticalDatum = verticalDatum.get().getCurrentVerticalDatum();
                if (currentVerticalDatum != null) {
                    currentVerticalDatum = currentVerticalDatum.toUpperCase();
                }
            }
            catch (VerticalDatumException e) {
                LOGGER.log(Level.FINER, e, () -> "No vertical datum information in time series, cannot convert to native datum: " + timeSeries.getTimeSeriesIdentifier());
            }
        }
        return currentVerticalDatum;
    }

    public static boolean cannotCombine(TimeSeries original, TimeSeries combine) {
        return !TimeSeriesCombine.canCombine(original, combine);
    }

    public static boolean canCombine(TimeSeries original, TimeSeries combine) {
        TimeSeriesIdentifier originalIdentifier = original.getTimeSeriesIdentifier();
        TimeSeriesIdentifier combineIdentifier = combine.getTimeSeriesIdentifier();
        boolean metadataMatches = original.getUnits().equals((Object)combine.getUnits()) && originalIdentifier.getParameter().getBaseParameter().equalsIgnoreCase(combineIdentifier.getParameter().getBaseParameter()) && originalIdentifier.getParameterType().equals((Object)combineIdentifier.getParameterType()) && originalIdentifier.getInterval().equals(combineIdentifier.getInterval()) && originalIdentifier.getDuration().equals((Object)combineIdentifier.getDuration());
        boolean intervalOffsetMatches = originalIdentifier.getIntervalOffset().isUndefined() || combineIdentifier.getIntervalOffset().isUndefined() || originalIdentifier.getIntervalOffset().equals((Object)combineIdentifier.getIntervalOffset());
        return metadataMatches && intervalOffsetMatches;
    }

    private boolean isProtected(Integer quality) {
        if (quality == null || Quality.isNotScreened_int(quality)) {
            return false;
        }
        return Quality.isProtected_int(quality);
    }

    private boolean isMissing(Integer quality, Double value) {
        if (quality == null || Quality.isNotScreened_int(quality)) {
            return !NumericalConstants.isValidValue((Double)value);
        }
        return Quality.isMissing_int(quality);
    }

    private Double mergeValueSameTime(Double original, Double combine, boolean originalMissing, boolean combinedMissing) {
        Double retval = original;
        switch (this._storeRule) {
            case DELETE_INSERT: 
            case REPLACE_ALL: {
                if (!NumericalConstants.isValidValue((Double)combine) && !combinedMissing) break;
                retval = combine;
                break;
            }
            case DO_NOT_REPLACE: {
                if (originalMissing || NumericalConstants.isValidValue((Double)original)) break;
                retval = combine;
                break;
            }
            case REPLACE_MISSING_VALUES_ONLY: {
                if (!originalMissing) break;
                retval = combine;
                break;
            }
            case REPLACE_WITH_NON_MISSING: {
                if (!NumericalConstants.isValidValue((Double)combine) || combinedMissing) break;
                retval = combine;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data Storage Rule NOT supported: " + this._storeRule);
            }
        }
        return retval;
    }

    private Integer mergeQualitySameTime(Integer original, Integer combine, boolean originalMissing, boolean combineMissing, boolean originalValid, boolean combineValid) {
        Integer retval = original == null ? Quality.emptyQualityValue() : original;
        switch (this._storeRule) {
            case DELETE_INSERT: 
            case REPLACE_ALL: {
                if (!combineValid && !combineMissing) break;
                retval = combine == null ? Quality.emptyQualityValue() : combine;
                break;
            }
            case DO_NOT_REPLACE: {
                if (originalMissing || originalValid) break;
                retval = combine == null ? Quality.emptyQualityValue() : combine;
                break;
            }
            case REPLACE_MISSING_VALUES_ONLY: {
                if (!originalMissing) break;
                retval = combine == null ? Quality.emptyQualityValue() : combine;
                break;
            }
            case REPLACE_WITH_NON_MISSING: {
                if (!combineValid || combineMissing) break;
                retval = combine == null ? Quality.emptyQualityValue() : combine;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data Storage Rule NOT supported: " + this._storeRule);
            }
        }
        return retval;
    }

    private void resetVerticalDatum(TimeSeries original, String originalCurrentVerticalDatum) throws DataSetTimeSeriesCombineException {
        Optional<VerticalDatum> verticalDatum;
        if (originalCurrentVerticalDatum != null && (verticalDatum = original.getVerticalDatum()).isPresent()) {
            try {
                verticalDatum.get().toVerticalDatum(originalCurrentVerticalDatum);
            }
            catch (VerticalDatumException e) {
                throw new DataSetTimeSeriesCombineException((Exception)((Object)e));
            }
        }
    }

    private static boolean areVerticalDatumsDifferent(String originalCurrentVerticalDatum, String combineCurrentVerticalDatum) {
        return originalCurrentVerticalDatum != null && !originalCurrentVerticalDatum.equalsIgnoreCase(combineCurrentVerticalDatum);
    }
}

