/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries.math;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.Optional;
import java.util.TimeZone;
import mil.army.usace.hec.data.timeseries.DataSetTimeSeriesDeriveException;
import mil.army.usace.hec.data.timeseries.DataSetTimeSeriesUnitsConversionException;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.TimeSeriesFactory;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTransferObject;
import mil.army.usace.hec.metadata.DataSetException;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.ParameterType;
import mil.army.usace.hec.metadata.UnitUtil;
import mil.army.usace.hec.metadata.Units;
import mil.army.usace.hec.metadata.UnitsConversionException;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;

public final class TimeSeriesDerive {
    public TimeSeries derive(TimeSeries original, TimeSeriesTemplate derive) throws DataSetException {
        TimeSeries retval;
        TimeSeries originalCopy = TimeSeriesFactory.copy(original);
        if (this.cannotDerive(originalCopy, derive)) {
            throw new DataSetTimeSeriesDeriveException("Cannot derive from:\n" + original.toString() + "\nTo:\n" + derive.toString());
        }
        TimeSeriesTransferObject transferTSData = new TimeSeriesTransferObject(originalCopy);
        transferTSData.setLocationId(derive.getTimeSeriesIdentifier().getLocationId());
        transferTSData.setVersion(derive.getTimeSeriesIdentifier().getVersion());
        transferTSData.setOfficeId(derive.getTimeSeriesIdentifier().getOfficeId().orElse(null));
        if (!"Stage".equalsIgnoreCase(originalCopy.getTimeSeriesIdentifier().getParameter().getBaseParameter()) || !"Elev".equalsIgnoreCase(derive.getTimeSeriesIdentifier().getParameter().getBaseParameter())) {
            transferTSData.setParameter(derive.getTimeSeriesIdentifier().getParameter());
        }
        if (this.needToChangeUnits(originalCopy, derive)) {
            transferTSData.setValues(this.convertUnits(originalCopy, derive));
            transferTSData.setUnits(derive.getUnits());
        }
        transferTSData.setInterval(derive.getTimeSeriesIdentifier().getInterval());
        transferTSData.setIntervalOffset(derive.getTimeSeriesIdentifier().getIntervalOffset());
        if (this.needToInterpolate(originalCopy, derive)) {
            this.interpolate(originalCopy, derive, transferTSData);
        }
        if (this.needToIncrementalDifference(originalCopy, derive)) {
            this.incrementalDifference(originalCopy, transferTSData);
        }
        if (this.needToWindow(retval = transferTSData.transferData(), derive)) {
            retval.window(derive);
        }
        retval.fillTails(derive);
        retval.setPreserveRejectedAndMissingValues(derive.getPreserveRejectedAndMissingValues());
        retval.setMaxTimeGap(derive.getMaxTimeGapMillis());
        return retval;
    }

    private boolean needToWindow(TimeSeries timeSeries, TimeSeriesTemplate derive) {
        long start = derive.getStartTime();
        long end = derive.getEndTime();
        return timeSeries.getStartTime().toInstant().toEpochMilli() != start || timeSeries.getEndTime().toInstant().toEpochMilli() != end;
    }

    private boolean needToIncrementalDifference(TimeSeries timeSeries, TimeSeriesTemplate derive) {
        return timeSeries.getTimeSeriesIdentifier().getParameterType().getParameterType().equals("Inst") && derive.getTimeSeriesIdentifier().getParameterType().getParameterType().equals("Total");
    }

    private void incrementalDifference(TimeSeries timeSeries, TimeSeriesTransferObject transferTSData) throws DataSetTimeSeriesDeriveException {
        if (timeSeries.getValues().length < 2) {
            throw new DataSetTimeSeriesDeriveException("Can not derive incremental differences for data set of length: " + timeSeries.getValues().length);
        }
        double[] newValues = new double[timeSeries.getValues().length - 1];
        long[] newTimes = new long[timeSeries.getValues().length - 1];
        long[] originalTimes = timeSeries.getTimes();
        Quality newQuality = null;
        boolean hasQuality = timeSeries.hasQuality();
        if (hasQuality) {
            newQuality = new Quality(timeSeries.getValues().length - 1);
        }
        Optional<Quality> originalQuality = timeSeries.getQuality();
        for (int i = 1; i < timeSeries.getValues().length; ++i) {
            if (this.canProcessValue(timeSeries, i - 1) && this.canProcessValue(timeSeries, i)) {
                newValues[i - 1] = timeSeries.getValues()[i] - timeSeries.getValues()[i - 1];
                if (originalQuality.isPresent() && newQuality != null) {
                    newQuality.setOkay(i - 1);
                    if (originalQuality.get().isQuestion(i - 1) || originalQuality.get().isQuestion(i)) {
                        newQuality.setQuestion(i - 1);
                    }
                }
            } else {
                newValues[i - 1] = -3.4028234663852886E38;
                if (originalQuality.isPresent() && newQuality != null) {
                    newQuality.setMissing(i - 1);
                    if (originalQuality.get().isReject(i - 1) || originalQuality.get().isReject(i)) {
                        newQuality.setReject(i - 1);
                    }
                }
            }
            newTimes[i - 1] = originalTimes[i];
        }
        transferTSData.setTimes(newTimes);
        transferTSData.setValues(newValues);
        transferTSData.setQuality(newQuality);
    }

    private boolean canProcessValue(TimeSeries timeSeries, int indexOfValue) {
        return !timeSeries.isMissing(indexOfValue) && !this.isReject(timeSeries, indexOfValue);
    }

    private boolean isReject(TimeSeries timeSeries, int index) {
        Optional<Quality> quality = timeSeries.getQuality();
        if (!quality.isPresent() || quality.get().isNotScreened(index)) {
            return false;
        }
        return quality.get().isReject(index);
    }

    private void interpolate(TimeSeries timeSeries, TimeSeriesTemplate derive, TimeSeriesTransferObject transferTSData) throws DataSetException {
        TimeSeriesIdentifier originalIdentifier = timeSeries.getTimeSeriesIdentifier();
        TimeSeriesIdentifier deriveIdentifier = derive.getTimeSeriesIdentifier();
        this.validateInterpolate(originalIdentifier, deriveIdentifier);
        double[] zeroValue = new double[]{0.0};
        TimeSeries checkTempDSTX = TimeSeriesFactory.buildTimeSeries(derive, derive.getStartTime(), zeroValue, null);
        boolean offsetsMatch = originalIdentifier.getIntervalOffset().getOffsetSeconds() == checkTempDSTX.getTimeSeriesIdentifier().getIntervalOffset().getOffsetSeconds();
        ZoneId originalZoneId = (ZoneId)originalIdentifier.getIntervalZoneId().orElseThrow(() -> new DataSetTimeSeriesIllegalArgumentException("Unable to derive a time series without a time zone"));
        ZoneId deriveZoneId = (ZoneId)deriveIdentifier.getIntervalZoneId().orElseThrow(() -> new DataSetTimeSeriesIllegalArgumentException("Unable to derive a time series without a time zone"));
        boolean bl = offsetsMatch = offsetsMatch && originalZoneId.getRules().equals(deriveZoneId.getRules());
        if (!offsetsMatch || !originalIdentifier.getInterval().equals(deriveIdentifier.getInterval())) {
            this.interpolateMismatchedOffsets(timeSeries, derive, transferTSData);
        }
    }

    private void interpolateMismatchedOffsets(TimeSeries timeSeries, TimeSeriesTemplate derive, TimeSeriesTransferObject transferTSData) throws DataSetException {
        if (!derive.getTimeSeriesIdentifier().getInterval().isIrregular()) {
            long[] times = timeSeries.getTimes();
            if (derive.getTimeSeriesIdentifier().getInterval().isRegular()) {
                this.validateIntepolateToRegular(timeSeries, derive, times);
                this.intepolateToRegular(timeSeries, derive, times, transferTSData);
            } else {
                this.validateIntepolateToLocalRegular(timeSeries, derive, times);
                this.intepolateToLocalRegular(timeSeries, derive, times, transferTSData);
            }
        }
    }

    private void intepolateToRegular(TimeSeries timeSeries, TimeSeriesTemplate derive, long[] times, TimeSeriesTransferObject transferTSData) throws DataSetException {
        TimeSeriesIdentifier deriveIdentifier = derive.getTimeSeriesIdentifier();
        double[] originalValues = timeSeries.getValues();
        long[] originalTimes = times;
        Quality originalQualityCopy = null;
        Optional<Quality> originalQuality = timeSeries.getQuality();
        if (originalQuality.isPresent()) {
            originalQualityCopy = new Quality(originalQuality.get());
        }
        Interval deriveInterval = deriveIdentifier.getInterval();
        double[] onlyGoodValues = timeSeries.getValuesWithQualityFlagsApplied();
        Quality onlyGoodQuality = this.getQualityClearedForValuesWithQualityFlagsApplied(timeSeries);
        timeSeries.set(timeSeries.getTimes(), onlyGoodValues, onlyGoodQuality);
        long lstartTime = derive.getStartTime();
        long lendTime = derive.getEndTime();
        long[] dataSetTxTimes = timeSeries.getTimes();
        boolean hasQuality = false;
        if (timeSeries.hasQuality()) {
            hasQuality = true;
        }
        Quality newQuality = null;
        int dataSetTxLastIndex = timeSeries.getValues().length - 1;
        long intervalMillis = deriveIdentifier.getInterval().getMillis();
        int numberOfNewValues = 1 + (int)((lendTime - lstartTime) / intervalMillis);
        double[] newValues = new double[numberOfNewValues];
        if (hasQuality) {
            newQuality = new Quality(numberOfNewValues);
        }
        long nextTime = lstartTime;
        int dataSetTxIndex = 0;
        if (timeSeries.getValues().length <= 0 && originalValues.length > 0) {
            int lastOrigIndex = 0;
            for (int i = 0; i < numberOfNewValues; ++i) {
                long tempTime = lstartTime + intervalMillis * (long)i;
                int origBeginIndex = lastOrigIndex;
                newValues[i] = -3.4028234663852886E38;
                if (newQuality != null) {
                    newQuality.setIntegerAt(0, i);
                }
                for (int j = origBeginIndex; j < originalValues.length && tempTime >= originalTimes[j]; ++j) {
                    if (tempTime == originalTimes[j] && originalQualityCopy != null && originalQualityCopy.getIntegerAt(j) != 0) {
                        newValues[i] = originalValues[j];
                        if (newQuality != null) {
                            newQuality.setIntegerAt(originalQualityCopy.getIntegerAt(j), i);
                        }
                    }
                    if (tempTime < originalTimes[j]) continue;
                    lastOrigIndex = j < originalValues.length ? j + 1 : j;
                }
            }
            transferTSData.setStartTime(derive.getStartTime());
            transferTSData.setEndTime(derive.getEndTime());
            transferTSData.setInterval(deriveIdentifier.getInterval());
            transferTSData.setTimes(new long[]{lstartTime});
            transferTSData.setValues(newValues);
            transferTSData.setQuality(newQuality);
        } else if (timeSeries.getValues().length <= 0) {
            for (int i = 0; i < numberOfNewValues; ++i) {
                newValues[i] = -3.4028234663852886E38;
                if (!hasQuality) continue;
                newQuality.setIntegerAt(0, i);
            }
            transferTSData.setStartTime(derive.getStartTime());
            transferTSData.setEndTime(derive.getEndTime());
            transferTSData.setInterval(deriveIdentifier.getInterval());
            transferTSData.setTimes(new long[]{lstartTime});
            transferTSData.setValues(newValues);
            transferTSData.setQuality(newQuality);
        } else {
            int newIndex;
            for (newIndex = 0; nextTime < dataSetTxTimes[0] && newIndex < numberOfNewValues - 1; ++newIndex) {
                newValues[newIndex] = -3.4028234663852886E38;
                if (hasQuality) {
                    newQuality.setIntegerAt(0, newIndex);
                }
                nextTime = deriveInterval.getNextIntervalTime(nextTime, NumericalConstants.UTC_TZ);
            }
            if (originalValues.length > 1) {
                double timeGap = 0.0;
                double inc = 0.0;
                double ratio = 0.0;
                while (newIndex < numberOfNewValues && nextTime <= dataSetTxTimes[dataSetTxLastIndex]) {
                    while (dataSetTxTimes[dataSetTxIndex] <= nextTime && dataSetTxIndex < dataSetTxLastIndex) {
                        ++dataSetTxIndex;
                    }
                    timeGap = dataSetTxTimes[dataSetTxIndex] - dataSetTxTimes[dataSetTxIndex - 1];
                    if (nextTime == dataSetTxTimes[dataSetTxIndex - 1]) {
                        newValues[newIndex] = originalValues[dataSetTxIndex - 1];
                        if (originalQuality.isPresent()) {
                            newQuality.setIntegerAt(originalQuality.get().getIntegerAt(dataSetTxIndex - 1), newIndex);
                            newQuality.clearProtected(newIndex);
                        }
                    } else if (this.canProcessValue(timeSeries, dataSetTxIndex - 1) && this.canProcessValue(timeSeries, dataSetTxIndex) && timeGap <= (double)timeSeries.getMaxTimeGap()) {
                        inc = originalValues[dataSetTxIndex] - originalValues[dataSetTxIndex - 1];
                        ratio = (double)(nextTime - dataSetTxTimes[dataSetTxIndex - 1]) / timeGap;
                        newValues[newIndex] = originalValues[dataSetTxIndex - 1] + inc * ratio;
                        if (originalQuality.isPresent()) {
                            newQuality.setIntegerAt(0, newIndex);
                            if (originalQuality.get().isOkay(dataSetTxIndex - 1) && originalQuality.get().isOkay(dataSetTxIndex)) {
                                newQuality.setOkay(newIndex);
                            }
                            if (originalQuality.get().isQuestion(dataSetTxIndex - 1) || originalQuality.get().isQuestion(dataSetTxIndex)) {
                                newQuality.setQuestion(newIndex);
                            }
                        }
                    } else {
                        newValues[newIndex] = -3.4028234663852886E38;
                        if (hasQuality) {
                            newQuality.setIntegerAt(0, newIndex);
                        }
                    }
                    ++newIndex;
                    nextTime = deriveInterval.getNextIntervalTime(nextTime, NumericalConstants.UTC_TZ);
                }
            } else if (originalValues.length == 1) {
                newValues[newIndex] = originalValues[0];
                if (hasQuality) {
                    newQuality.setIntegerAt(originalQualityCopy.getIntegerAt(0), newIndex);
                }
                ++newIndex;
                nextTime = deriveInterval.getNextIntervalTime(nextTime, NumericalConstants.UTC_TZ);
            }
            if (nextTime - intervalMillis == dataSetTxTimes[dataSetTxLastIndex]) {
                newValues[newIndex - 1] = onlyGoodValues[dataSetTxLastIndex];
                if (hasQuality) {
                    newQuality.setIntegerAt(onlyGoodQuality.getIntegerAt(dataSetTxLastIndex), newIndex - 1);
                }
            }
            while (newIndex < numberOfNewValues) {
                newValues[newIndex] = -3.4028234663852886E38;
                if (hasQuality) {
                    newQuality.setIntegerAt(0, newIndex);
                }
                ++newIndex;
            }
            int lastOrigIndex = 0;
            for (int i = 0; i < numberOfNewValues; ++i) {
                int origBeginIndex;
                long tempTime = lstartTime + intervalMillis * (long)i;
                for (int j = origBeginIndex = lastOrigIndex; j < originalValues.length && tempTime >= originalTimes[j]; ++j) {
                    if (tempTime == originalTimes[j] && originalQualityCopy != null && originalQualityCopy.getIntegerAt(j) != 0) {
                        newValues[i] = originalValues[j];
                        newQuality.setIntegerAt(originalQualityCopy.getIntegerAt(j), i);
                    }
                    if (tempTime < originalTimes[j]) continue;
                    lastOrigIndex = j < originalValues.length ? j + 1 : j;
                }
            }
            if (numberOfNewValues > 0) {
                transferTSData.setValues(newValues);
                transferTSData.setTimes(new long[]{lstartTime});
                transferTSData.setQuality(newQuality);
                transferTSData.setInterval(deriveIdentifier.getInterval());
                transferTSData.setIntervalOffset(deriveIdentifier.getIntervalOffset());
                transferTSData.setStartTime(lstartTime);
                transferTSData.setEndTime(lendTime);
            } else {
                transferTSData.setStartTime(derive.getStartTime());
                transferTSData.setEndTime(derive.getEndTime());
                transferTSData.setInterval(deriveIdentifier.getInterval());
            }
        }
    }

    private void intepolateToLocalRegular(TimeSeries timeSeries, TimeSeriesTemplate derive, long[] times, TimeSeriesTransferObject transferTSData) throws DataSetException {
        TimeSeriesIdentifier deriveIdentifier = derive.getTimeSeriesIdentifier();
        ZoneId deriveZoneId = (ZoneId)deriveIdentifier.getIntervalZoneId().orElseThrow(() -> new DataSetTimeSeriesIllegalArgumentException("Unable to derive a time series without a time zone"));
        double[] originalValues = timeSeries.getValues();
        long[] originalTimes = times;
        Quality originalQualityCopy = null;
        Optional<Quality> originalQuality = timeSeries.getQuality();
        if (originalQuality.isPresent()) {
            originalQualityCopy = new Quality(originalQuality.get());
        }
        Interval deriveInterval = deriveIdentifier.getInterval();
        double[] onlyGoodValues = timeSeries.getValuesWithQualityFlagsApplied();
        Quality onlyGoodQuality = this.getQualityClearedForValuesWithQualityFlagsApplied(timeSeries);
        timeSeries.set(timeSeries.getTimes(), onlyGoodValues, onlyGoodQuality);
        long lstartTime = derive.getStartTime();
        long lendTime = derive.getEndTime();
        long[] dataSetTxTimes = timeSeries.getTimes();
        boolean hasQuality = false;
        if (timeSeries.hasQuality()) {
            hasQuality = true;
        }
        Quality newQuality = null;
        int dataSetTxLastIndex = onlyGoodValues.length - 1;
        int numberOfNewValues = deriveIdentifier.getInterval().getNumIntervalPoints(lstartTime, lendTime, TimeZone.getTimeZone(deriveZoneId));
        double[] newValues = new double[numberOfNewValues];
        if (hasQuality) {
            newQuality = new Quality(numberOfNewValues);
        }
        long nextTime = lstartTime;
        int dataSetTxIndex = 0;
        if (timeSeries.getValues().length <= 0 && originalValues.length > 0) {
            int lastOrigIndex = 0;
            for (int i = 0; i < numberOfNewValues; ++i) {
                long tempTime = deriveInterval.getNextIntervalTime(lstartTime, (long)i, TimeZone.getTimeZone(deriveZoneId));
                int origBeginIndex = lastOrigIndex;
                newValues[i] = -3.4028234663852886E38;
                if (newQuality != null) {
                    newQuality.setIntegerAt(0, i);
                }
                for (int j = origBeginIndex; j < originalValues.length && tempTime >= originalTimes[j]; ++j) {
                    if (tempTime == originalTimes[j] && originalQualityCopy != null && originalQualityCopy.getIntegerAt(j) != 0) {
                        newValues[i] = originalValues[j];
                        if (newQuality != null) {
                            newQuality.setIntegerAt(originalQualityCopy.getIntegerAt(j), i);
                        }
                    }
                    if (tempTime < originalTimes[j]) continue;
                    lastOrigIndex = j < originalValues.length ? j + 1 : j;
                }
            }
            transferTSData.setStartTime(derive.getStartTime());
            transferTSData.setEndTime(derive.getEndTime());
            transferTSData.setInterval(deriveIdentifier.getInterval());
            transferTSData.setTimes(new long[]{lstartTime});
            transferTSData.setValues(newValues);
            transferTSData.setQuality(newQuality);
        } else if (timeSeries.getValues().length <= 0) {
            for (int i = 0; i < numberOfNewValues; ++i) {
                newValues[i] = -3.4028234663852886E38;
                if (!hasQuality) continue;
                newQuality.setIntegerAt(0, i);
            }
            transferTSData.setStartTime(derive.getStartTime());
            transferTSData.setEndTime(derive.getEndTime());
            transferTSData.setInterval(deriveIdentifier.getInterval());
            transferTSData.setTimes(new long[]{lstartTime});
            transferTSData.setValues(newValues);
            transferTSData.setQuality(newQuality);
        } else {
            int newIndex;
            for (newIndex = 0; nextTime < dataSetTxTimes[0] && newIndex < numberOfNewValues - 1; ++newIndex) {
                newValues[newIndex] = -3.4028234663852886E38;
                if (hasQuality) {
                    newQuality.setIntegerAt(0, newIndex);
                }
                nextTime = deriveInterval.getNextIntervalTime(nextTime, TimeZone.getTimeZone(deriveZoneId));
            }
            if (originalValues.length > 1) {
                double timeGap = 0.0;
                double inc = 0.0;
                double ratio = 0.0;
                while (newIndex < numberOfNewValues && nextTime <= dataSetTxTimes[dataSetTxLastIndex]) {
                    while (dataSetTxTimes[dataSetTxIndex] <= nextTime && dataSetTxIndex < dataSetTxLastIndex) {
                        ++dataSetTxIndex;
                    }
                    timeGap = dataSetTxTimes[dataSetTxIndex] - dataSetTxTimes[dataSetTxIndex - 1];
                    if (nextTime == dataSetTxTimes[dataSetTxIndex - 1]) {
                        newValues[newIndex] = originalValues[dataSetTxIndex - 1];
                        if (originalQuality.isPresent()) {
                            newQuality.setIntegerAt(originalQuality.get().getIntegerAt(dataSetTxIndex - 1), newIndex);
                            newQuality.clearProtected(newIndex);
                        }
                    } else if (this.canProcessValue(timeSeries, dataSetTxIndex - 1) && this.canProcessValue(timeSeries, dataSetTxIndex) && timeGap <= (double)timeSeries.getMaxTimeGap()) {
                        inc = originalValues[dataSetTxIndex] - originalValues[dataSetTxIndex - 1];
                        ratio = (double)(nextTime - dataSetTxTimes[dataSetTxIndex - 1]) / timeGap;
                        newValues[newIndex] = originalValues[dataSetTxIndex - 1] + inc * ratio;
                        if (originalQuality.isPresent()) {
                            newQuality.setIntegerAt(0, newIndex);
                            if (originalQuality.get().isOkay(dataSetTxIndex - 1) && originalQuality.get().isOkay(dataSetTxIndex)) {
                                newQuality.setOkay(newIndex);
                            }
                            if (originalQuality.get().isQuestion(dataSetTxIndex - 1) || originalQuality.get().isQuestion(dataSetTxIndex)) {
                                newQuality.setQuestion(newIndex);
                            }
                        }
                    } else {
                        newValues[newIndex] = -3.4028234663852886E38;
                        if (hasQuality) {
                            newQuality.setIntegerAt(0, newIndex);
                        }
                    }
                    ++newIndex;
                    nextTime = deriveInterval.getNextIntervalTime(nextTime, TimeZone.getTimeZone(deriveZoneId));
                }
            } else if (originalValues.length == 1) {
                newValues[newIndex] = originalValues[0];
                if (hasQuality) {
                    newQuality.setIntegerAt(originalQualityCopy.getIntegerAt(0), newIndex);
                }
                ++newIndex;
                nextTime = deriveInterval.getNextIntervalTime(nextTime, TimeZone.getTimeZone(deriveZoneId));
            }
            if (deriveInterval.getPreviousIntervalTime(nextTime, TimeZone.getTimeZone(deriveZoneId)) == dataSetTxTimes[dataSetTxLastIndex]) {
                newValues[newIndex - 1] = onlyGoodValues[dataSetTxLastIndex];
                if (hasQuality) {
                    newQuality.setIntegerAt(onlyGoodQuality.getIntegerAt(dataSetTxLastIndex), newIndex - 1);
                }
            }
            while (newIndex < numberOfNewValues) {
                newValues[newIndex] = -3.4028234663852886E38;
                if (hasQuality) {
                    newQuality.setIntegerAt(0, newIndex);
                }
                ++newIndex;
            }
            int lastOrigIndex = 0;
            for (int i = 0; i < numberOfNewValues; ++i) {
                int origBeginIndex;
                long tempTime = deriveInterval.getNextIntervalTime(lstartTime, (long)i, TimeZone.getTimeZone(deriveZoneId));
                for (int j = origBeginIndex = lastOrigIndex; j < originalValues.length && tempTime >= originalTimes[j]; ++j) {
                    if (tempTime == originalTimes[j] && originalQualityCopy != null && originalQualityCopy.getIntegerAt(j) != 0) {
                        newValues[i] = originalValues[j];
                        newQuality.setIntegerAt(originalQualityCopy.getIntegerAt(j), i);
                    }
                    if (tempTime < originalTimes[j]) continue;
                    lastOrigIndex = j < originalValues.length ? j + 1 : j;
                }
            }
            if (numberOfNewValues > 0) {
                transferTSData.setValues(newValues);
                transferTSData.setTimes(new long[]{lstartTime});
                transferTSData.setQuality(newQuality);
                transferTSData.setInterval(deriveIdentifier.getInterval());
                transferTSData.setIntervalOffset(deriveIdentifier.getIntervalOffset());
                transferTSData.setStartTime(lstartTime);
                transferTSData.setEndTime(lendTime);
            } else {
                transferTSData.setStartTime(derive.getStartTime());
                transferTSData.setEndTime(derive.getEndTime());
                transferTSData.setInterval(deriveIdentifier.getInterval());
            }
        }
    }

    private void validateIntepolateIrregularToRegular(TimeSeriesIdentifier originalIdentifier, TimeSeriesTemplate derive, long[] times) throws DataSetIllegalArgumentException {
        TimeSeriesIdentifier deriveIdentifier = derive.getTimeSeriesIdentifier();
        if (!deriveIdentifier.getParameterType().getParameterType().equals("Inst") && times.length > 0) {
            long startTime = derive.getStartTime();
            if (startTime != Long.MIN_VALUE && startTime != times[0]) {
                throw new DataSetIllegalArgumentException("Derive cannot interpolate irregular to non-Inst regular with inconsistent starting times - From: " + originalIdentifier.getParameter().toString() + "." + originalIdentifier.getParameterType().getParameterType() + "." + originalIdentifier.getInterval().toString() + "." + originalIdentifier.getDuration().toString() + " To: " + deriveIdentifier.getParameter().toString() + "." + deriveIdentifier.getParameterType().getParameterType() + "." + deriveIdentifier.getInterval().toString() + "." + deriveIdentifier.getDuration().toString());
            }
            long intvlMillis = deriveIdentifier.getInterval().getMillis();
            for (int i = 1; i < times.length; ++i) {
                if (times[i] - times[i - 1] == intvlMillis) continue;
                throw new DataSetIllegalArgumentException("Derive cannot interpolate irregular to non-Inst regular with inconsistent times - From: " + originalIdentifier.getParameter().toString() + "." + originalIdentifier.getParameterType().getParameterType() + "." + originalIdentifier.getInterval().toString() + "." + originalIdentifier.getDuration().toString() + " To: " + deriveIdentifier.getParameter().toString() + "." + deriveIdentifier.getParameterType().getParameterType() + "." + deriveIdentifier.getInterval().toString() + "." + deriveIdentifier.getDuration().toString());
            }
        }
    }

    private void validateIntepolateToRegular(TimeSeries timeSeries, TimeSeriesTemplate derive, long[] times) throws DataSetIllegalArgumentException {
        TimeSeriesIdentifier originalIdentifier = timeSeries.getTimeSeriesIdentifier();
        if (originalIdentifier.getInterval().isIrregular()) {
            this.validateIntepolateIrregularToRegular(originalIdentifier, derive, times);
        } else {
            TimeSeriesIdentifier deriveIdentifier = derive.getTimeSeriesIdentifier();
            if (!originalIdentifier.getParameterType().getParameterType().equals("Inst")) {
                throw new DataSetIllegalArgumentException("Derive cannot interpolate regular non-Inst datasets with inconsistent intervals or times - From: " + originalIdentifier.getParameter().toString() + "." + originalIdentifier.getParameterType().getParameterType() + "." + originalIdentifier.getInterval().toString() + "." + originalIdentifier.getDuration().toString() + " To: " + deriveIdentifier.getParameter().toString() + "." + deriveIdentifier.getParameterType().getParameterType() + "." + deriveIdentifier.getInterval().toString() + "." + deriveIdentifier.getDuration().toString());
            }
        }
    }

    private void validateIntepolateToLocalRegular(TimeSeries original, TimeSeriesTemplate derive, long[] times) throws DataSetIllegalArgumentException {
        TimeSeriesIdentifier originalIdentifier = original.getTimeSeriesIdentifier();
        TimeSeriesIdentifier deriveIdentifier = derive.getTimeSeriesIdentifier();
        if (originalIdentifier.getInterval().isIrregular()) {
            if (!deriveIdentifier.getParameterType().getParameterType().equals("Inst") && times.length > 0) {
                long startTime = derive.getStartTime();
                if (startTime != Long.MIN_VALUE && startTime != times[0]) {
                    throw new DataSetIllegalArgumentException("Derive cannot interpolate irregular to non-Inst regular with inconsistent starting times - From: " + originalIdentifier.getParameter().toString() + "." + originalIdentifier.getParameterType().getParameterType() + "." + originalIdentifier.getInterval().toString() + "." + originalIdentifier.getDuration().toString() + " To: " + deriveIdentifier.getParameter().toString() + "." + deriveIdentifier.getParameterType().getParameterType() + "." + deriveIdentifier.getInterval().toString() + "." + deriveIdentifier.getDuration().toString());
                }
                long intvlMillis = deriveIdentifier.getInterval().getMillis();
                for (int i = 1; i < times.length; ++i) {
                    if (times[i] - times[i - 1] == intvlMillis) continue;
                    throw new DataSetIllegalArgumentException("Derive cannot interpolate irregular to non-Inst regular with inconsistent times - From: " + originalIdentifier.getParameter().toString() + "." + originalIdentifier.getParameterType().getParameterType() + "." + originalIdentifier.getInterval().toString() + "." + originalIdentifier.getDuration().toString() + " To: " + deriveIdentifier.getParameter().toString() + "." + deriveIdentifier.getParameterType().getParameterType() + "." + deriveIdentifier.getInterval().toString() + "." + deriveIdentifier.getDuration().toString());
                }
            }
        } else if (!originalIdentifier.getParameterType().getParameterType().equals("Inst")) {
            throw new DataSetIllegalArgumentException("Derive cannot interpolate regular non-Inst datasets with inconsistent intervals or times - From: " + originalIdentifier.getParameter().toString() + "." + originalIdentifier.getParameterType().getParameterType() + "." + originalIdentifier.getInterval().toString() + "." + originalIdentifier.getDuration().toString() + " To: " + deriveIdentifier.getParameter().toString() + "." + deriveIdentifier.getParameterType().getParameterType() + "." + deriveIdentifier.getInterval().toString() + "." + deriveIdentifier.getDuration().toString());
        }
    }

    private void validateInterpolate(TimeSeriesIdentifier originalIdentifier, TimeSeriesIdentifier deriveIdentifier) throws DataSetIllegalArgumentException {
        boolean elevToStage;
        boolean bl = elevToStage = "elev".equalsIgnoreCase(originalIdentifier.getParameter().getBaseParameter()) && "stage".equalsIgnoreCase(deriveIdentifier.getParameter().getBaseParameter());
        if (!deriveIdentifier.getParameter().baseParameterMatches(originalIdentifier.getParameter()) && !elevToStage) {
            throw new DataSetIllegalArgumentException("Derive cannot interpolate into a dataset with a different parameter - From: " + originalIdentifier.getParameter().toString() + "." + originalIdentifier.getParameterType().getParameterType() + "." + originalIdentifier.getInterval().toString() + "." + originalIdentifier.getDuration().toString() + " To: " + deriveIdentifier.getParameter().toString() + "." + deriveIdentifier.getParameterType().getParameterType() + "." + deriveIdentifier.getInterval().toString() + "." + deriveIdentifier.getDuration().toString());
        }
        if (!deriveIdentifier.getParameterType().equals((Object)originalIdentifier.getParameterType())) {
            throw new DataSetIllegalArgumentException("Derive cannot interpolate into a dataset with a different parameter type - From: " + originalIdentifier.getParameter().toString() + "." + originalIdentifier.getParameterType().getParameterType() + "." + originalIdentifier.getInterval().toString() + "." + originalIdentifier.getDuration().toString() + " To: " + deriveIdentifier.getParameter().toString() + "." + deriveIdentifier.getParameterType().getParameterType() + "." + deriveIdentifier.getInterval().toString() + "." + deriveIdentifier.getDuration().toString());
        }
        if (deriveIdentifier.getDuration().getSeconds() != originalIdentifier.getDuration().getSeconds()) {
            throw new DataSetIllegalArgumentException("Derive cannot interpolate into a dataset with a different duration - From: " + originalIdentifier.getParameter().toString() + "." + originalIdentifier.getParameterType().getParameterType() + "." + originalIdentifier.getInterval().toString() + "." + originalIdentifier.getDuration().toString() + " To: " + deriveIdentifier.getParameter().toString() + "." + deriveIdentifier.getParameterType().getParameterType() + "." + deriveIdentifier.getInterval().toString() + "." + deriveIdentifier.getDuration().toString());
        }
    }

    public boolean cannotDerive(TimeSeries timeSeries, TimeSeriesTemplate derive) {
        return !this.canDerive(timeSeries, derive);
    }

    public boolean canDerive(TimeSeries timeSeries, TimeSeriesTemplate dataSetTx) {
        TimeSeriesIdentifier originalIdentifier = timeSeries.getTimeSeriesIdentifier();
        TimeSeriesIdentifier deriveIdentifier = dataSetTx.getTimeSeriesIdentifier();
        if (originalIdentifier.getParameter().baseParameterMatches(deriveIdentifier.getParameter())) {
            return true;
        }
        return "elev".equalsIgnoreCase(originalIdentifier.getParameter().getBaseParameter()) && "stage".equalsIgnoreCase(deriveIdentifier.getParameter().getBaseParameter());
    }

    private boolean needToChangeUnits(TimeSeries timeSeries, TimeSeriesTemplate derive) throws DataSetTimeSeriesDeriveException {
        Units originalUnits = timeSeries.getUnits();
        if (originalUnits == null) {
            throw new DataSetTimeSeriesDeriveException("Units are null for Dataset: \n" + timeSeries.getTimeSeriesIdentifier().toString());
        }
        if (derive.getUnits() == null) {
            throw new DataSetTimeSeriesDeriveException("Units are null for Dataset: \n" + derive.getTimeSeriesIdentifier().toString());
        }
        if (originalUnits.equals((Object)derive.getUnits())) {
            return false;
        }
        return !"undef".equals(derive.getUnits().toString());
    }

    private double[] convertUnits(TimeSeries timeSeries, TimeSeriesTemplate derive) throws DataSetTimeSeriesDeriveException {
        try {
            double[] values = Arrays.copyOf(timeSeries.getValues(), timeSeries.getValues().length);
            UnitUtil.convertUnits((double[])values, (String)timeSeries.getUnits().toString(), (String)derive.getUnits().toString());
            return values;
        }
        catch (UnitsConversionException e) {
            throw new DataSetTimeSeriesUnitsConversionException("Error converting units in time series derive function", e);
        }
    }

    private boolean needToInterpolate(TimeSeries timeSeries, TimeSeriesTemplate derive) {
        Interval interval2 = derive.getTimeSeriesIdentifier().getInterval();
        if (interval2.isIrregular()) {
            return false;
        }
        Interval interval = timeSeries.getTimeSeriesIdentifier().getInterval();
        ParameterType parameterType = timeSeries.getTimeSeriesIdentifier().getParameterType();
        ParameterType parameterType2 = derive.getTimeSeriesIdentifier().getParameterType();
        return !interval.equals(interval2) || !parameterType.equals((Object)parameterType2) || timeSeries.getStartTime().toInstant().toEpochMilli() != derive.getStartTime() || timeSeries.getEndTime().toInstant().toEpochMilli() != derive.getEndTime();
    }

    private Quality getQualityClearedForValuesWithQualityFlagsApplied(TimeSeries timeSeries) {
        Quality clearQuality = null;
        Optional<Quality> originalQuality = timeSeries.getQuality();
        if (originalQuality.isPresent()) {
            clearQuality = new Quality(originalQuality.get());
            for (int i = 0; i < timeSeries.getNumberValues(); ++i) {
                if (timeSeries.isMissing(i)) {
                    clearQuality.setIntegerAt(0, i);
                }
                if (originalQuality.get().isReject(i)) {
                    clearQuality.setIntegerAt(0, i);
                }
                clearQuality.clearProtected(i);
            }
        }
        return clearQuality;
    }
}

