/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries.math;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.IntervalOffset;
import mil.army.usace.hec.metadata.Units;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;

public final class TimeSeriesTemplate
implements Serializable {
    private static final long serialVersionUID = -6665000036135286182L;
    private static final Logger LOGGER = Logger.getLogger(TimeSeriesTemplate.class.getName());
    private TimeSeriesIdentifier _timeSeriesIdentifier = null;
    private long _startTime = Long.MIN_VALUE;
    private long _endTime = Long.MIN_VALUE;
    private Units _units = new Units();
    private boolean _preserveRejectedAndMissingValues = true;
    private long _maxTimeGap = 0L;

    public TimeSeriesTemplate() {
    }

    public TimeSeriesTemplate(TimeSeriesIdentifier description) throws DataSetTimeSeriesIllegalArgumentException {
        this(description, Long.MIN_VALUE, Long.MIN_VALUE, null, true, 0L);
    }

    public TimeSeriesTemplate(TimeSeriesIdentifier description, long startTime, long endTime) throws DataSetTimeSeriesIllegalArgumentException {
        this(description, startTime, endTime, null, true, 0L);
    }

    public TimeSeriesTemplate(TimeSeriesIdentifier description, Instant startTime, Instant endTime) throws DataSetTimeSeriesIllegalArgumentException {
        this(description, startTime.toEpochMilli(), endTime.toEpochMilli(), null, true, 0L);
    }

    public TimeSeriesTemplate(TimeSeriesIdentifier description, Units units) throws DataSetTimeSeriesIllegalArgumentException {
        this(description, Long.MIN_VALUE, Long.MIN_VALUE, units, true, 0L);
    }

    public TimeSeriesTemplate(TimeSeriesIdentifier description, long startTime, long endTime, Units units) throws DataSetTimeSeriesIllegalArgumentException {
        this(description, startTime, endTime, units, true, 0L);
    }

    public TimeSeriesTemplate(TimeSeriesIdentifier description, long startTime, long endTime, Units units, boolean preserveRejectedAndMissingValues, int maxTimeGapDefinedByIntervals) throws DataSetTimeSeriesIllegalArgumentException {
        this(description, startTime, endTime, units, preserveRejectedAndMissingValues, 0L);
        this.setMaxTimeGapDefinedByIntervals(maxTimeGapDefinedByIntervals);
    }

    public TimeSeriesTemplate(TimeSeriesIdentifier description, long startTime, long endTime, Units units, boolean preserveRejectedAndMissingValues, long maxTimeGap) throws DataSetTimeSeriesIllegalArgumentException {
        this._preserveRejectedAndMissingValues = preserveRejectedAndMissingValues;
        this._maxTimeGap = maxTimeGap;
        if (startTime == Long.MAX_VALUE) {
            startTime = Long.MIN_VALUE;
        }
        if (endTime == Long.MAX_VALUE) {
            endTime = Long.MIN_VALUE;
        }
        if (startTime != Long.MIN_VALUE && endTime != Long.MIN_VALUE && startTime > endTime) {
            throw new DataSetTimeSeriesIllegalArgumentException("Can not instantiate a Time Series with the start time greater than the end time.");
        }
        if (description == null) {
            throw new DataSetTimeSeriesIllegalArgumentException("Can not instantiate a Time Series template with a null identifier.");
        }
        this._timeSeriesIdentifier = description;
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        this._units = units == null ? new Units() : new Units(units);
    }

    public TimeSeriesTemplate(TimeSeriesTemplate dstxt) {
        this._preserveRejectedAndMissingValues = dstxt._preserveRejectedAndMissingValues;
        this._maxTimeGap = dstxt._maxTimeGap;
        this._timeSeriesIdentifier = dstxt._timeSeriesIdentifier;
        try {
            this.setStartTime(dstxt.getStartTime());
            this.setEndTime(dstxt.getEndTime());
        }
        catch (DataSetTimeSeriesIllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, "Internal state of the time series template is invalid. Unable to correctly copy start and end times", e);
        }
        this._units = new Units(dstxt._units);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeSeriesTemplate that = (TimeSeriesTemplate)o;
        return this.getStartTime() == that.getStartTime() && this.getEndTime() == that.getEndTime() && this.getPreserveRejectedAndMissingValues() == that.getPreserveRejectedAndMissingValues() && this.getMaxTimeGapMillis() == that.getMaxTimeGapMillis() && this.getTimeSeriesIdentifier().equals(that.getTimeSeriesIdentifier()) && Objects.equals(this.getUnits(), that.getUnits());
    }

    public int hashCode() {
        return Objects.hash(this.getTimeSeriesIdentifier(), this.getStartTime(), this.getEndTime(), this.getUnits(), this.getPreserveRejectedAndMissingValues(), this.getMaxTimeGapMillis());
    }

    public final String toString() {
        return this.toString(TimeZone.getTimeZone(this.getTimeSeriesIdentifier().getIntervalZoneId().orElse(NumericalConstants.UTC_ZONEID)));
    }

    public final String toString(TimeZone timeZone) {
        SimpleDateFormat sdfFULL = NumericalConstants.sdfFULL();
        sdfFULL.setTimeZone(timeZone);
        long startTime = this.getStartTime();
        String startDate = startTime == Long.MIN_VALUE ? "--Undefined--" : sdfFULL.format(new Date(startTime));
        long endTime = this.getEndTime();
        String endDate = endTime == Long.MIN_VALUE ? "--Undefined--" : sdfFULL.format(new Date(endTime));
        IntervalOffset intervalOffsetFromBaseSec = this._timeSeriesIdentifier.getIntervalOffset();
        return "   -->Description: " + this._timeSeriesIdentifier.toString() + ";\n   -->Start Time: " + startDate + ";\n   -->End Time:   " + endDate + ";\n   -->Interval Offset from " + timeZone.getID() + ": " + intervalOffsetFromBaseSec.toString() + ";\n   -->Units: " + this._units + ";\n   -->Preserve: " + this._preserveRejectedAndMissingValues + ";\n   -->MaxTimeGap: " + this._maxTimeGap / 60000L + " Mins  or  " + this._maxTimeGap / 3600000L + " Hours";
    }

    public final Units getUnits() {
        return this._units;
    }

    public final void setUnits(Units units) {
        this._units = units;
    }

    public final boolean getPreserveRejectedAndMissingValues() {
        return this._preserveRejectedAndMissingValues;
    }

    public final void setPreserveRejectedAndMissingValues(boolean preserveRejectedAndMissingValues) {
        this._preserveRejectedAndMissingValues = preserveRejectedAndMissingValues;
    }

    public final void setMaxTimeGapDefinedByIntervals(int maxTimeGapDefinedByIntervals) {
        long millisInterval = this._timeSeriesIdentifier.getInterval().getMillis();
        this._maxTimeGap = (long)maxTimeGapDefinedByIntervals * millisInterval;
    }

    public final void setMaxTimeGapDefinedByMinutes(int maxTimeGapDefinedByMinutes) {
        this._maxTimeGap = TimeUnit.MINUTES.toMillis(maxTimeGapDefinedByMinutes);
    }

    public final void setMaxTimeGapDefinedByHours(int maxTimeGapDefinedByHours) {
        this._maxTimeGap = TimeUnit.HOURS.toMillis(maxTimeGapDefinedByHours);
    }

    public final long getMaxTimeGapMillis() {
        return this._maxTimeGap;
    }

    public final void setMaxTimeGap(long maxTimeGap) {
        this._maxTimeGap = maxTimeGap;
    }

    public final String getStartTimeString() {
        return this.getStartTimeString("UTC");
    }

    public final String getStartTimeString(String timeZone) {
        SimpleDateFormat sdfFULL = NumericalConstants.sdfFULL();
        sdfFULL.setTimeZone(TimeZone.getTimeZone(timeZone));
        return sdfFULL.format(new Date(this.getStartTime()));
    }

    public final String getEndTimeString() {
        return this.getEndTimeString("UTC");
    }

    public final String getEndTimeString(String timeZone) {
        SimpleDateFormat sdfFULL = NumericalConstants.sdfFULL();
        sdfFULL.setTimeZone(TimeZone.getTimeZone(timeZone));
        return sdfFULL.format(new Date(this.getEndTime()));
    }

    public final long getStartTime() {
        return this._startTime;
    }

    public final void setStartTime(long startTime) throws DataSetTimeSeriesIllegalArgumentException {
        if (startTime != Long.MIN_VALUE && this._endTime != Long.MIN_VALUE && startTime > this._endTime) {
            SimpleDateFormat sdfFULL = NumericalConstants.sdfFULL();
            sdfFULL.setTimeZone(TimeZone.getTimeZone("UTC"));
            String strEnd = sdfFULL.format(this._endTime);
            String strStart = sdfFULL.format(startTime);
            throw new DataSetTimeSeriesIllegalArgumentException("Can not set the start time (" + strStart + ") greater than the end time (" + strEnd + ").");
        }
        this._startTime = startTime;
    }

    public final long getEndTime() {
        return this._endTime;
    }

    public final void setEndTime(long endTime) throws DataSetTimeSeriesIllegalArgumentException {
        if (endTime != Long.MIN_VALUE && this._startTime != Long.MIN_VALUE && endTime < this._startTime) {
            SimpleDateFormat sdfFULL = NumericalConstants.sdfFULL();
            sdfFULL.setTimeZone(TimeZone.getTimeZone("UTC"));
            String strEnd = sdfFULL.format(endTime);
            String strStart = sdfFULL.format(this._startTime);
            throw new DataSetTimeSeriesIllegalArgumentException("Can not set the end time (" + strEnd + ") less than the start time (" + strStart + ").");
        }
        this._endTime = endTime;
    }

    public final void clearTimeWindow() {
        try {
            this.setStartTime(Long.MIN_VALUE);
            this.setEndTime(Long.MIN_VALUE);
        }
        catch (DataSetTimeSeriesIllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, "Interval state of class has been corrupted. Unable to correctly clear time window");
        }
    }

    public final TimeSeriesIdentifier getTimeSeriesIdentifier() {
        return this._timeSeriesIdentifier;
    }
}

