/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries.math;

import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.TimeSeriesFactory;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.DataSetException;
import mil.army.usace.hec.metadata.Duration;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalOffset;
import mil.army.usace.hec.metadata.LocationID;
import mil.army.usace.hec.metadata.OfficeId;
import mil.army.usace.hec.metadata.Parameter;
import mil.army.usace.hec.metadata.ParameterType;
import mil.army.usace.hec.metadata.Units;
import mil.army.usace.hec.metadata.Version;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifierFactory;

final class TimeSeriesTransferObject {
    private OfficeId _officeId = null;
    private Long _endTime = null;
    private Long _startTime = null;
    private Parameter _parameter = null;
    private ParameterType _parameterType = null;
    private IntervalOffset _intervalOffset = null;
    private Interval _interval = null;
    private Quality _quality = null;
    private long[] _times = null;
    private double[] _values = null;
    private Units _units = null;
    private Version _version = null;
    private LocationID _locationId = null;
    private Duration _duration = null;
    private Long _maxGap = null;
    private Boolean _preserveRejectedAndMissingValues = null;
    private final VerticalDatumContainer _verticalDatumContainer;

    TimeSeriesTransferObject(TimeSeries timeSeries) {
        TimeSeriesIdentifier timeSeriesIdentifier = timeSeries.getTimeSeriesIdentifier();
        this._officeId = timeSeriesIdentifier.getOfficeId().orElse(null);
        this._endTime = timeSeries.getEndTime().toInstant().toEpochMilli();
        this._startTime = timeSeries.getStartTime().toInstant().toEpochMilli();
        this._parameter = timeSeriesIdentifier.getParameter();
        this._parameterType = timeSeriesIdentifier.getParameterType();
        this._intervalOffset = timeSeriesIdentifier.getIntervalOffset();
        this._interval = timeSeriesIdentifier.getInterval();
        this._quality = timeSeries.getQuality().orElse(null);
        this._times = timeSeries.getTimes();
        this._values = timeSeries.getValues();
        this._units = timeSeries.getUnits();
        this._version = timeSeriesIdentifier.getVersion();
        this._locationId = timeSeriesIdentifier.getLocationId();
        this._duration = timeSeriesIdentifier.getDuration();
        this._maxGap = timeSeries.getMaxTimeGap();
        this._preserveRejectedAndMissingValues = timeSeries.getPreserveRejectedAndMissingValues();
        this._verticalDatumContainer = timeSeries.getVerticalDatum().map(VerticalDatum::getVerticalDatumContainer).orElse(null);
    }

    OfficeId getOfficeId() {
        return this._officeId;
    }

    void setOfficeId(OfficeId officeId) {
        this._officeId = officeId;
    }

    Long getEndTime() {
        return this._endTime;
    }

    void setEndTime(long endTime) {
        this._endTime = endTime;
    }

    Long getStartTime() {
        return this._startTime;
    }

    void setStartTime(long startTime) {
        this._startTime = startTime;
    }

    Parameter getParameter() {
        return this._parameter;
    }

    void setParameter(Parameter parameter) {
        this._parameter = parameter;
    }

    ParameterType getParameterType() {
        return this._parameterType;
    }

    void setParameterType(ParameterType parameterType) {
        this._parameterType = parameterType;
    }

    IntervalOffset getIntervalOffset() {
        return this._intervalOffset;
    }

    void setIntervalOffset(IntervalOffset intervalOffset) {
        this._intervalOffset = intervalOffset;
    }

    Interval getInterval() {
        return this._interval;
    }

    void setInterval(Interval interval) {
        this._interval = interval;
    }

    Quality getQuality() {
        return this._quality;
    }

    void setQuality(Quality quality) {
        this._quality = quality;
    }

    long[] getTimes() {
        return this._times;
    }

    void setTimes(long[] times) {
        this._times = times;
    }

    double[] getValues() {
        return this._values;
    }

    void setValues(double[] values) {
        this._values = values;
    }

    Units getUnits() {
        return this._units;
    }

    void setUnits(Units units) {
        this._units = units;
    }

    Version getVersion() {
        return this._version;
    }

    void setVersion(Version version) {
        this._version = version;
    }

    LocationID getLocationId() {
        return this._locationId;
    }

    void setLocationId(LocationID locationId) {
        this._locationId = locationId;
    }

    Duration getDuration() {
        return this._duration;
    }

    void setDuration(Duration duration) {
        this._duration = duration;
    }

    Long getMaxGap() {
        return this._maxGap;
    }

    void setMaxGap(long maxGap) {
        this._maxGap = maxGap;
    }

    Boolean getPreserveRejectedAndMissingValues() {
        return this._preserveRejectedAndMissingValues;
    }

    void setPreserveRejectedAndMissingValues(boolean preserveRejectedAndMissingValues) {
        this._preserveRejectedAndMissingValues = preserveRejectedAndMissingValues;
    }

    TimeSeries transferData() throws DataSetException {
        TimeSeriesIdentifier newTsid = TimeSeriesIdentifierFactory.from((OfficeId)this.getOfficeId(), (LocationID)this.getLocationId(), (Parameter)this.getParameter(), (ParameterType)this.getParameterType(), (Interval)this.getInterval(), (Duration)this.getDuration(), (Version)this.getVersion(), (IntervalOffset)this.getIntervalOffset());
        TimeSeriesTemplate newTemplate = new TimeSeriesTemplate(newTsid, (long)this.getStartTime(), (long)this.getEndTime(), this.getUnits(), (boolean)this.getPreserveRejectedAndMissingValues(), this.getMaxGap());
        return TimeSeriesFactory.buildTimeSeries(newTemplate, this.getTimes(), this.getValues(), this.getQuality(), this._verticalDatumContainer);
    }
}

