/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries.profile;

import java.util.Objects;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;

public final class DataColumnInfo {
    private final String _name;
    private final int _ordinal;
    private final String _dataType;

    public DataColumnInfo(String name, int ordinal, String dataType) throws DataSetIllegalArgumentException {
        this._name = Objects.requireNonNull(name);
        this._ordinal = ordinal;
        this._dataType = Objects.requireNonNull(dataType);
        this.validate();
    }

    public String getName() {
        return this._name;
    }

    public int getOrdinal() {
        return this._ordinal;
    }

    public String getDataType() {
        return this._dataType;
    }

    private void validate() throws DataSetIllegalArgumentException {
        if (this._name == null || this._name.isBlank()) {
            throw new DataSetIllegalArgumentException("Data column name cannot be null or blank.");
        }
        if (this._ordinal < 0) {
            throw new DataSetIllegalArgumentException("Data column ordinal cannot be negative.");
        }
        if (this._dataType == null || this._dataType.isBlank()) {
            throw new DataSetIllegalArgumentException("Data column data type cannot be null or blank.");
        }
    }
}

