/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries.profile;

import java.util.Objects;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;

public final class ParameterColumnInfo {
    private final String _parameter;
    private final int _ordinal;
    private final String _unit;

    public ParameterColumnInfo(String parameter, int ordinal, String unit) throws DataSetIllegalArgumentException {
        this._parameter = Objects.requireNonNull(parameter, "Parameter cannot be null and must be provided.");
        this._ordinal = ordinal;
        this._unit = Objects.requireNonNull(unit, "Unit cannot be null and must be provided.");
        this.validate();
    }

    public String getParameter() {
        return this._parameter;
    }

    public int getOrdinal() {
        return this._ordinal;
    }

    public String getUnit() {
        return this._unit;
    }

    private void validate() throws DataSetIllegalArgumentException {
        if (this._ordinal < 0) {
            throw new DataSetIllegalArgumentException("Ordinal must be greater than or equal to 0.");
        }
        if (this._parameter.isBlank()) {
            throw new DataSetIllegalArgumentException("Parameter cannot be empty.");
        }
        if (this._unit.isBlank()) {
            throw new DataSetIllegalArgumentException("Unit cannot be empty.");
        }
    }
}

