/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries.profile;

import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.VersionDate;
import mil.army.usace.hec.data.timeseries.profile.TimeSeriesProfile;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;

public final class TimeSeriesProfileInstance {
    private final TimeSeriesProfile _timeSeriesProfile;
    private final List<TimeSeries> _timeSeriesList;
    private final String _version;
    private final VersionDate _versionDate;
    private final String _locationTimeZone;

    private TimeSeriesProfileInstance(Builder builder) {
        this._timeSeriesList = Collections.unmodifiableList(builder._timeSeriesList);
        this._timeSeriesProfile = Objects.requireNonNull(builder._timeSeriesProfile);
        this._version = Objects.requireNonNull(builder._version);
        this._versionDate = Objects.requireNonNull(builder._versionDate);
        this._locationTimeZone = builder._locationTimeZone;
    }

    public TimeSeriesProfile getTimeSeriesProfile() {
        return this._timeSeriesProfile;
    }

    public List<TimeSeries> getTimeSeriesList() {
        return this._timeSeriesList;
    }

    public String getVersion() {
        return this._version;
    }

    public Optional<VersionDate> getVersionDate() {
        return Optional.ofNullable(this._versionDate);
    }

    public String getLocationTimeZone() {
        return this._locationTimeZone;
    }

    public static final class Builder {
        private List<TimeSeries> _timeSeriesList;
        private TimeSeriesProfile _timeSeriesProfile;
        private String _version;
        private VersionDate _versionDate;
        private String _locationTimeZone;
        private Instant _firstDate;
        private Instant _lastDate;

        public Builder withTimeSeriesProfile(TimeSeriesProfile timeSeriesProfile) {
            this._timeSeriesProfile = timeSeriesProfile;
            return this;
        }

        public Builder withTimeSeriesList(List<TimeSeries> timeSeriesList) {
            this._timeSeriesList = Collections.unmodifiableList(timeSeriesList);
            return this;
        }

        public Builder withVersion(String version) {
            this._version = version;
            return this;
        }

        public Builder withVersionDate(VersionDate versionDate) {
            this._versionDate = versionDate;
            return this;
        }

        public Builder withLocationTimeZone(String locationTimeZone) {
            this._locationTimeZone = locationTimeZone;
            return this;
        }

        public Builder withFirstDate(Instant firstDate) {
            this._firstDate = firstDate;
            return this;
        }

        public Builder withLastDate(Instant lastDate) {
            this._lastDate = lastDate;
            return this;
        }

        public TimeSeriesProfileInstance build() throws DataSetIllegalArgumentException {
            this.validate();
            return new TimeSeriesProfileInstance(this);
        }

        private void validate() throws DataSetIllegalArgumentException {
            if (this._firstDate != null && this._lastDate != null && this._firstDate.isAfter(this._lastDate)) {
                throw new DataSetIllegalArgumentException("First date cannot be after last date");
            }
            if (this._versionDate == null) {
                throw new DataSetIllegalArgumentException("Version date is required");
            }
            if (this._version == null) {
                throw new DataSetIllegalArgumentException("Version is required");
            }
            if (this._timeSeriesProfile == null) {
                throw new DataSetIllegalArgumentException("Time series profile is required");
            }
            if (this._timeSeriesList == null) {
                throw new DataSetIllegalArgumentException("Time series list is required");
            }
        }
    }
}

