/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries.profile;

import java.util.Objects;
import java.util.Optional;
import mil.army.usace.hec.data.timeseries.VersionDate;
import mil.army.usace.hec.data.timeseries.profile.TimeSeriesProfile;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;

public final class TimeSeriesProfileInstanceRef {
    private final TimeSeriesProfile _timeSeriesProfile;
    private final String _version;
    private final VersionDate _versionDate;

    private TimeSeriesProfileInstanceRef(Builder builder) {
        this._timeSeriesProfile = Objects.requireNonNull(builder._timeSeriesProfile);
        this._version = Objects.requireNonNull(builder._version);
        this._versionDate = Objects.requireNonNull(builder._versionDate);
    }

    public TimeSeriesProfile getTimeSeriesProfile() {
        return this._timeSeriesProfile;
    }

    public String getVersion() {
        return this._version;
    }

    public Optional<VersionDate> getVersionDate() {
        return Optional.of(this._versionDate);
    }

    public static final class Builder {
        private TimeSeriesProfile _timeSeriesProfile;
        private String _version;
        private VersionDate _versionDate;

        public Builder withTimeSeriesProfile(TimeSeriesProfile timeSeriesProfile) {
            this._timeSeriesProfile = timeSeriesProfile;
            return this;
        }

        public Builder withVersion(String version) {
            this._version = version;
            return this;
        }

        public Builder withVersionDate(VersionDate versionDate) {
            this._versionDate = versionDate;
            return this;
        }

        public TimeSeriesProfileInstanceRef build() throws DataSetIllegalArgumentException {
            this.validate();
            return new TimeSeriesProfileInstanceRef(this);
        }

        private void validate() throws DataSetIllegalArgumentException {
            if (this._versionDate == null) {
                throw new DataSetIllegalArgumentException("Version date is required");
            }
            if (this._version == null) {
                throw new DataSetIllegalArgumentException("Version is required");
            }
            if (this._timeSeriesProfile == null) {
                throw new DataSetIllegalArgumentException("Time series profile is required");
            }
        }
    }
}

