/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.data.timeseries.profile;

import java.util.List;
import mil.army.usace.hec.data.timeseries.profile.ParameterInfo;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.location.LocationTemplate;

public class TimeSeriesProfileParser<T extends ParameterInfo> {
    private final char _recordDelimiter;
    private final LocationTemplate _locationTemplate;
    private final String _keyParameter;
    private final String _timeZone;
    private final String _timeFormat;
    private final List<T> _parameterList;
    private final boolean _timeInTwoFields;

    protected TimeSeriesProfileParser(Builder<T> builder) {
        this._recordDelimiter = builder._recordDelimiter;
        this._timeFormat = builder._timeFormat;
        this._parameterList = builder._parameterInfoList;
        this._timeInTwoFields = builder._timeInTwoFields;
        this._locationTemplate = builder._locationTemplate;
        this._keyParameter = builder._keyParameter;
        this._timeZone = builder._timeZone;
    }

    public char getRecordDelimiter() {
        return this._recordDelimiter;
    }

    public String getTimeFormat() {
        return this._timeFormat;
    }

    public List<T> getParameterList() {
        return this._parameterList;
    }

    public boolean getTimeInTwoFields() {
        return this._timeInTwoFields;
    }

    public LocationTemplate getLocationTemplate() {
        return this._locationTemplate;
    }

    public String getKeyParameter() {
        return this._keyParameter;
    }

    public String getTimeZone() {
        return this._timeZone;
    }

    public static class Builder<T extends ParameterInfo> {
        private char _recordDelimiter;
        private String _timeFormat;
        private List<T> _parameterInfoList;
        private boolean _timeInTwoFields;
        private LocationTemplate _locationTemplate;
        private String _keyParameter;
        private String _timeZone;

        public Builder<T> recordDelimiter(char recordDelimiter) {
            this._recordDelimiter = recordDelimiter;
            return this;
        }

        public Builder<T> timeFormat(String timeFormat) {
            this._timeFormat = timeFormat;
            return this;
        }

        public Builder<T> parameterInfoList(List<T> parameterInfoList) {
            this._parameterInfoList = parameterInfoList;
            return this;
        }

        public Builder<T> locationTemplate(LocationTemplate locationTemplate) {
            this._locationTemplate = locationTemplate;
            return this;
        }

        public Builder<T> keyParameter(String keyParameter) {
            this._keyParameter = keyParameter;
            return this;
        }

        public Builder<T> timeZone(String timeZone) {
            this._timeZone = timeZone;
            return this;
        }

        public Builder<T> timeInTwoFields(boolean timeInTwoFields) {
            this._timeInTwoFields = timeInTwoFields;
            return this;
        }

        public TimeSeriesProfileParser<T> build() throws DataSetIllegalArgumentException {
            this.validate();
            return new TimeSeriesProfileParser(this);
        }

        protected void validate() throws DataSetIllegalArgumentException {
            if (this._keyParameter == null || this._keyParameter.isEmpty()) {
                throw new DataSetIllegalArgumentException("Key parameter is required");
            }
            if (this._locationTemplate == null) {
                throw new DataSetIllegalArgumentException("Location template is required");
            }
        }
    }
}

