/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.cwms.http.client;

import com.auth0.jwt.interfaces.DecodedJWT;
import java.time.Instant;
import java.util.Date;

final class AccessTokenValidator {
    private static final String REFRESH_EXPIRED_BUFFER_PROPERTY_KEY = "cwms.http.client.token.refresh.buffer.millis";
    private static final long DEFAULT_REFRESH_EXPIRED_BUFFER_SECONDS = 1L;

    private AccessTokenValidator() {
        throw new AssertionError((Object)"Utility class");
    }

    static boolean isTokenExpired(DecodedJWT jwt) {
        long bufferMillis = Instant.ofEpochSecond(1L).toEpochMilli();
        String bufferStr = System.getProperty(REFRESH_EXPIRED_BUFFER_PROPERTY_KEY);
        if (bufferStr != null) {
            bufferMillis = Long.parseLong(bufferStr);
        }
        Instant noLongerValid = Instant.now().minusMillis(bufferMillis);
        return jwt.getExpiresAt().before(Date.from(noLongerValid));
    }
}

