/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.cwms.http.client;

import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import mil.army.usace.hec.cwms.http.client.ApiConnectionInfo;
import mil.army.usace.hec.cwms.http.client.AuthCookieCallback;
import mil.army.usace.hec.cwms.http.client.CookieAuthenticator;
import mil.army.usace.hec.cwms.http.client.CookieJarFactory;
import mil.army.usace.hec.cwms.http.client.OAuth2TokenAuthenticator;
import mil.army.usace.hec.cwms.http.client.OAuth2TokenInterceptor;
import mil.army.usace.hec.cwms.http.client.SimpleAuthHeaderAuthenticator;
import mil.army.usace.hec.cwms.http.client.SimpleAuthHeaderInterceptor;
import mil.army.usace.hec.cwms.http.client.SslSocketData;
import mil.army.usace.hec.cwms.http.client.auth.OAuth2TokenProvider;
import mil.army.usace.hec.cwms.http.client.auth.SimpleAuthKeyProvider;
import okhttp3.Authenticator;
import okhttp3.CookieJar;
import okhttp3.Interceptor;

public class ApiConnectionInfoBuilder {
    private static final String SINGLE_AUTH_ERROR_MESSAGE = "Only a single authentication type is supported at this time";
    private final String apiRoot;
    private OAuth2TokenProvider tokenProvider;
    private SslSocketData sslSocketData;
    private CookieJarFactory.CookieJarSupplier cookieJarSupplier;
    private CookieAuthenticator cookieAuthenticator;
    private SimpleAuthKeyProvider simpleAuthKeyProvider;
    private HostnameVerifier hostnameVerifier;

    public ApiConnectionInfoBuilder(String apiRoot) {
        this.apiRoot = apiRoot;
    }

    public ApiConnectionInfoBuilder withSslSocketData(SslSocketData sslSocketData) {
        this.sslSocketData = sslSocketData;
        return this;
    }

    public ApiConnectionInfoBuilder withTokenProvider(OAuth2TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
        return this;
    }

    public ApiConnectionInfoBuilder withCookieJarSupplier(CookieJarFactory.CookieJarSupplier cookieJarSupplier) {
        this.cookieJarSupplier = cookieJarSupplier;
        return this;
    }

    public ApiConnectionInfoBuilder withCookieAuthenticator(AuthCookieCallback callback) {
        this.cookieAuthenticator = new CookieAuthenticator(callback);
        return this;
    }

    public ApiConnectionInfoBuilder withAuthorizationKeyProvider(SimpleAuthKeyProvider simpleAuthKeyProvider) {
        this.simpleAuthKeyProvider = simpleAuthKeyProvider;
        return this;
    }

    public ApiConnectionInfoBuilder withHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public ApiConnectionInfo build() {
        CookieJar cookieJar = null;
        if (this.cookieJarSupplier != null) {
            cookieJar = this.cookieJarSupplier.getCookieJar();
        }
        Object authenticator = null;
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        if (this.tokenProvider != null) {
            authenticator = new OAuth2TokenAuthenticator(this.tokenProvider);
            interceptors.add(new OAuth2TokenInterceptor(this.tokenProvider));
        }
        if (this.simpleAuthKeyProvider != null) {
            if (this.tokenProvider != null) {
                throw new IllegalArgumentException("Cannot setup ApiConnectionInfo with both a OAuth2TokenProvider and SimpleAuthKeyProvider. Only a single authentication type is supported at this time");
            }
            authenticator = new SimpleAuthHeaderAuthenticator(this.simpleAuthKeyProvider);
            interceptors.add(new SimpleAuthHeaderInterceptor(this.simpleAuthKeyProvider));
        }
        if (this.cookieAuthenticator != null) {
            if (this.tokenProvider != null) {
                throw new IllegalArgumentException("Cannot setup ApiConnectionInfo with both a OAuth2TokenProvider and CookieAuthenticator. Only a single authentication type is supported at this time");
            }
            if (this.simpleAuthKeyProvider != null) {
                throw new IllegalArgumentException("Cannot setup ApiConnectionInfo with both a SimpleAuthKeyProvider and CookieAuthenticator. Only a single authentication type is supported at this time");
            }
            authenticator = this.cookieAuthenticator;
        }
        return new ApiConnectionInfo(this.apiRoot, this.sslSocketData, cookieJar, (List<Interceptor>)interceptors, (Authenticator)authenticator, this.hostnameVerifier);
    }
}

