/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.cwms.http.client;

import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.util.List;
import java.util.Optional;
import mil.army.usace.hec.cwms.http.client.HttpCookie;
import mil.army.usace.hec.cwms.http.client.OkHttpCookieWrapper;
import mil.army.usace.hec.cwms.http.client.PreferencesBackedCookieStore;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.JavaNetCookieJar;

public final class CookieJarFactory {
    private CookieJarFactory() {
        throw new AssertionError((Object)"Utility class");
    }

    public static CookieJarSupplier inMemoryCookieJar() {
        return new InMemoryCookieJarSupplier();
    }

    public static CookieJarSupplier preferenceBackedCookieJar(PreferencesBackedCookieStore cookieStore) {
        return new InMemoryCookieJarSupplier(cookieStore);
    }

    private static final class InMemoryCookieJarSupplier
    extends CookieJarSupplier {
        private final JavaNetCookieJar cookieJar;

        private InMemoryCookieJarSupplier() {
            CookieManager cookieManager = new CookieManager(null, CookiePolicy.ACCEPT_ORIGINAL_SERVER);
            this.cookieJar = new JavaNetCookieJar((CookieHandler)cookieManager);
        }

        private InMemoryCookieJarSupplier(CookieStore store) {
            CookieManager cookieManager = new CookieManager(store, CookiePolicy.ACCEPT_ORIGINAL_SERVER);
            this.cookieJar = new JavaNetCookieJar((CookieHandler)cookieManager);
        }

        @Override
        CookieJar getCookieJar() {
            return this.cookieJar;
        }
    }

    public static abstract class CookieJarSupplier {
        abstract CookieJar getCookieJar();

        public boolean isCookieExpired(String apiRootUrl, String cookieName) {
            CookieJar cookieJar = this.getCookieJar();
            List cookies = cookieJar.loadForRequest(HttpUrl.get((String)apiRootUrl));
            if (cookies.isEmpty()) {
                return true;
            }
            return cookies.stream().filter(c -> c.name().equalsIgnoreCase(cookieName)).anyMatch(c -> c.expiresAt() < System.currentTimeMillis());
        }

        public Optional<? extends HttpCookie> getCookie(String url, String cookieName) {
            CookieJar cookieJar = this.getCookieJar();
            return cookieJar.loadForRequest(HttpUrl.get((String)url)).stream().filter(c -> c.name().equalsIgnoreCase(cookieName)).map(OkHttpCookieWrapper::new).findFirst();
        }
    }
}

