/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.cwms.http.client;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.cwms.http.client.CwmsHttpLogger;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;

final class CwmsHttpLoggingInterceptor
implements Interceptor {
    private static final Logger LOGGER = Logger.getLogger(CwmsHttpLoggingInterceptor.class.getName());
    private static final String SET_COOKIE_HEADER = "Set-Cookie";
    private static final String COOKIE_HEADER = "Cookie";
    private static CwmsHttpLoggingInterceptor instance;
    private final CwmsHttpLogger cwmsHttpLogger = new CwmsHttpLogger();
    private final HttpLoggingInterceptor delegate = new HttpLoggingInterceptor((HttpLoggingInterceptor.Logger)this.cwmsHttpLogger);

    private CwmsHttpLoggingInterceptor() {
        this.updateInterceptorLogLevel();
        if (!Boolean.getBoolean("cwms.http.client.log.all.cookies")) {
            this.redactHeader(SET_COOKIE_HEADER);
            this.redactHeader(COOKIE_HEADER);
        }
    }

    static CwmsHttpLoggingInterceptor getInstance() {
        if (instance == null) {
            instance = new CwmsHttpLoggingInterceptor();
        }
        return instance;
    }

    private void updateInterceptorLogLevel() {
        if (LOGGER.isLoggable(Level.ALL)) {
            this.delegate.level(HttpLoggingInterceptor.Level.BODY);
        } else if (LOGGER.isLoggable(Level.FINE)) {
            this.delegate.level(HttpLoggingInterceptor.Level.BASIC);
        }
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return this.delegate.intercept(chain);
    }

    void redactHeader(String header) {
        this.delegate.redactHeader(header);
    }

    void setLogLevel(Level level) {
        LOGGER.setLevel(level);
        this.updateInterceptorLogLevel();
    }

    void logStackTraceForRequest(Request request) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, new Exception("Stack Trace Logging"), () -> "CWMS HTTP API executing request: " + request.url());
        }
    }
}

