/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.cwms.http.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.util.lookup.Lookup;
import usace.metrics.services.MetricsApp;
import usace.metrics.services.MetricsService;
import usace.metrics.services.MetricsServiceProvider;
import usace.metrics.services.MetricsUtil;
import usace.metrics.services.config.MetricsConfig;
import usace.metrics.services.config.MetricsConfigBuilder;

public final class CwmsHttpMetricsServiceProvider
implements MetricsServiceProvider {
    static final String SERVICE_PATH = "cwmshttp_metrics";
    static final int SERVICE_POSITION = 0;
    private static final Logger LOGGER = Logger.getLogger(CwmsHttpMetricsServiceProvider.class.getName());
    private MetricsService service;

    private MetricsApp getMetricsApp() {
        return (MetricsApp)Lookup.getDefault().lookup(MetricsApp.class);
    }

    private void init() {
        MetricsApp app = this.getMetricsApp();
        String appName = this.getAppName(app);
        Properties cwmsConfig = this.getConfigurationFile(appName);
        MetricsConfig config = this.buildMetricsConfig(cwmsConfig, app, appName);
        this.service = new MetricsService(config);
    }

    private MetricsConfig buildMetricsConfig(Properties cwmsConfig, MetricsApp app, String appName) {
        MetricsConfigBuilder builder = new MetricsConfigBuilder();
        if (cwmsConfig != null) {
            builder.withPropertiesFile(cwmsConfig);
        }
        MetricsConfig appConfig = null;
        if (app != null) {
            appConfig = app.getAppConfig();
        }
        Properties appOverrides = this.buildCwmsOverrideProperties(appName);
        builder.withPropertiesFile(appOverrides);
        if (appConfig != null) {
            builder.withBackingConfiguration(appConfig);
        }
        return builder.withSystemPropertyOptions().build();
    }

    private Properties buildCwmsOverrideProperties(String appName) {
        Properties appOverrides = new Properties();
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd kkmm-ss");
        String filePrefix = format.format(now);
        appOverrides.setProperty("metrics-file-location", "CwmsHttp" + appName);
        appOverrides.setProperty("metrics-file-prefix", filePrefix);
        return appOverrides;
    }

    private String getAppName(MetricsApp app) {
        String appName = "";
        if (app != null && (appName = app.getAppName()) == null) {
            appName = "";
        }
        return appName;
    }

    private Properties getConfigurationFile(String appName) {
        String configFileProperty = this.getConfigPropertyName(appName);
        Properties output = null;
        try {
            output = MetricsUtil.readPropertiesFromSystemProperty((String)configFileProperty);
        }
        catch (FileNotFoundException ex) {
            LOGGER.log(Level.WARNING, "Unable to find file for CwmsHttp Metrics configuration.", ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Exception occurred while reading CwmsHttp metrics configuration file.", ex);
        }
        return output;
    }

    private String getConfigPropertyName(String appName) {
        String configFileProperty = "cwms.http";
        if (!appName.isEmpty()) {
            configFileProperty = configFileProperty + "." + appName.toLowerCase();
        }
        configFileProperty = configFileProperty + ".config";
        return configFileProperty;
    }

    public synchronized MetricsService getMetricsService() {
        if (this.service == null) {
            this.init();
        }
        return this.service;
    }
}

