/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.cwms.http.client;

import java.io.IOException;
import java.util.Optional;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;

public class CwmsHttpResponseException
extends IOException {
    private static final String ERROR_MESSAGE = "Unknown error occurred for request: %s %s \nError code: %s %s %s";
    private final String reasonPhrase;
    private final String url;
    private final int errorCode;
    private final String responseBody;
    private final String requestType;
    private final String requestBody;

    CwmsHttpResponseException(Response execute, Request request, ResponseBody responseBody) throws IOException {
        this.reasonPhrase = execute.message();
        this.url = request.url().toString();
        this.errorCode = execute.code();
        this.requestType = request.method();
        this.responseBody = responseBody == null ? null : responseBody.string();
        RequestBody requestBody = request.body();
        if (requestBody == null) {
            this.requestBody = null;
        } else {
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            this.requestBody = buffer.readUtf8();
        }
    }

    public final String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public final String getUrl() {
        return this.url;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final String getRequestType() {
        return this.requestType;
    }

    public final Optional<String> getResponseBody() {
        return Optional.ofNullable(this.responseBody);
    }

    public final Optional<String> getRequestBody() {
        return Optional.ofNullable(this.requestBody);
    }

    @Override
    public String getMessage() {
        return String.format(ERROR_MESSAGE, this.getRequestType(), this.getUrl(), this.getErrorCode(), this.getReasonPhrase(), this.getResponseBody().map(c -> "\n" + c).orElse(""));
    }
}

