/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.cwms.http.client;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.SSLHandshakeException;
import mil.army.usace.hec.cwms.http.client.ApiConnectionInfo;
import mil.army.usace.hec.cwms.http.client.CwmsHttpClientMetrics;
import mil.army.usace.hec.cwms.http.client.CwmsHttpLoggingInterceptor;
import mil.army.usace.hec.cwms.http.client.CwmsHttpResponseException;
import mil.army.usace.hec.cwms.http.client.DataAlreadyExistsException;
import mil.army.usace.hec.cwms.http.client.EndpointInput;
import mil.army.usace.hec.cwms.http.client.Http2Util;
import mil.army.usace.hec.cwms.http.client.HttpCookie;
import mil.army.usace.hec.cwms.http.client.HttpRequestBuilder;
import mil.army.usace.hec.cwms.http.client.HttpRequestResponse;
import mil.army.usace.hec.cwms.http.client.NoDataFoundException;
import mil.army.usace.hec.cwms.http.client.OkHttpClientFactory;
import mil.army.usace.hec.cwms.http.client.OkHttpCookieWrapper;
import mil.army.usace.hec.cwms.http.client.ServerNotFoundException;
import mil.army.usace.hec.cwms.http.client.SslCanceledException;
import mil.army.usace.hec.cwms.http.client.UnauthorizedException;
import mil.army.usace.hec.cwms.http.client.request.HttpPostRequest;
import mil.army.usace.hec.cwms.http.client.request.HttpPutRequest;
import mil.army.usace.hec.cwms.http.client.request.HttpRequestExecutor;
import mil.army.usace.hec.cwms.http.client.request.HttpRequestMediaType;
import mil.army.usace.hec.cwms.http.client.request.HttpRequestMethod;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import usace.metrics.noop.NoOpTimer;
import usace.metrics.services.Metrics;
import usace.metrics.services.Timer;

public class HttpRequestBuilderImpl
implements HttpRequestBuilder {
    private final String endpoint;
    private final HttpUrl httpUrl;
    private final Map<String, String> queryParameters = new HashMap<String, String>();
    private final Map<String, String> queryHeaders = new HashMap<String, String>();
    private final ApiConnectionInfo apiConnectionInfo;
    private HttpRequestMethod method;
    private String body;
    private String mediaType;

    public HttpRequestBuilderImpl(ApiConnectionInfo apiConnectionInfo, String endpoint) throws IOException {
        Objects.requireNonNull(apiConnectionInfo, "API connection info must be defined");
        String apiRoot = apiConnectionInfo.getApiRoot();
        Objects.requireNonNull(apiRoot, "API root must be defined");
        HttpUrl url = HttpUrl.parse((String)apiRoot);
        if (url == null) {
            throw new ServerNotFoundException("Invalid HTTP URL: " + apiRoot, apiRoot);
        }
        this.httpUrl = url;
        this.endpoint = Objects.requireNonNull(endpoint, "Cannot process request against the API root endpoint");
        this.apiConnectionInfo = apiConnectionInfo;
    }

    public HttpRequestBuilderImpl(ApiConnectionInfo apiConnectionInfo) throws IOException {
        this(apiConnectionInfo, "");
    }

    @Override
    public final HttpRequestBuilderImpl addQueryParameter(String key, String value) {
        if (value == null) {
            this.queryParameters.remove(key);
        } else {
            this.queryParameters.put(key, value);
        }
        return this;
    }

    @Override
    public final HttpRequestBuilderImpl addQueryHeader(String key, String value) {
        if (value == null) {
            this.queryParameters.remove(key);
        } else {
            this.queryHeaders.put(key, value);
        }
        return this;
    }

    @Override
    public final HttpRequestBuilderImpl addEndpointInput(EndpointInput endpointInput) {
        endpointInput.addInputParameters(this);
        return this;
    }

    @Override
    public HttpRequestBuilder enableHttp2() {
        if (!Http2Util.isHttp2NativelySupported()) {
            Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
            Security.insertProviderAt((Provider)new BouncyCastleJsseProvider(), 2);
        }
        return this;
    }

    @Override
    public final HttpPostRequest post() {
        this.method = HttpRequestMethod.POST;
        return new HttpPostRequestImpl();
    }

    @Override
    public final HttpPutRequest put() {
        this.method = HttpRequestMethod.POST;
        return new HttpPutRequestImpl();
    }

    @Override
    public final HttpPostRequest patch() {
        this.method = HttpRequestMethod.PATCH;
        return new HttpPostRequestImpl();
    }

    @Override
    public final HttpRequestMediaType delete() {
        this.method = HttpRequestMethod.DELETE;
        return new HttpRequiredMediaTypeImpl();
    }

    @Override
    public final HttpRequestMediaType get() {
        this.method = HttpRequestMethod.GET;
        return new HttpRequiredMediaTypeImpl();
    }

    protected OkHttpClient buildOkHttpClient() {
        return OkHttpClientFactory.buildOkHttpClient(this.apiConnectionInfo);
    }

    Request createRequest() throws IOException {
        MediaType type;
        HttpUrl resolve = this.httpUrl;
        if (!this.endpoint.isEmpty()) {
            resolve = this.httpUrl.newBuilder().addPathSegments(this.endpoint).build();
        }
        if ((type = MediaType.parse((String)this.mediaType)) == null) {
            throw new IOException("Invalid Media Type: " + this.mediaType);
        }
        HttpUrl.Builder urlBuilder = resolve.newBuilder();
        this.queryParameters.forEach((arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
        Request.Builder requestBuilder = new Request.Builder();
        RequestBody requestBody = null;
        if (this.body != null) {
            requestBody = RequestBody.create((String)this.body, null);
        }
        requestBuilder.header("Content-Type", type.toString());
        requestBuilder.url(urlBuilder.build());
        requestBuilder.method(this.method.getName(), requestBody);
        this.queryHeaders.forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        return requestBuilder.build();
    }

    HttpRequestBuilderImpl getCurrentInstance() {
        return this;
    }

    class HttpRequestExecutorImpl
    implements HttpRequestExecutor {
        HttpRequestExecutorImpl() {
        }

        @Override
        public final HttpRequestResponse execute() throws IOException {
            HttpRequestResponse retVal = null;
            Request request = HttpRequestBuilderImpl.this.createRequest();
            CwmsHttpLoggingInterceptor.getInstance().logStackTraceForRequest(request);
            try (Timer.Context timer = this.createTimer().start();){
                OkHttpClient client = HttpRequestBuilderImpl.this.buildOkHttpClient();
                Response execute = client.newCall(request).execute();
                if (execute.isSuccessful()) {
                    ResponseBody responseBody = execute.body();
                    if (responseBody == null) {
                        throw new IOException("Error with request, body not returned for request: " + request);
                    }
                    Set<HttpCookie> cookies = client.cookieJar().loadForRequest(request.url()).stream().map(OkHttpCookieWrapper::new).collect(Collectors.toSet());
                    Headers headers = execute.headers();
                    retVal = new HttpRequestResponse(responseBody, cookies, headers);
                } else {
                    this.handleExecutionError(execute, request);
                }
            }
            catch (ConnectException | SocketTimeoutException | UnknownHostException connectException) {
                throw new ServerNotFoundException(connectException, request.url().toString());
            }
            catch (SSLHandshakeException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof SignatureException && cause.getMessage().contains("The action was cancelled by the user.")) {
                    throw new SslCanceledException(ex, request.url().toString());
                }
                throw ex;
            }
            return retVal;
        }

        private void handleExecutionError(Response execute, Request request) throws IOException {
            try (ResponseBody responseBody = execute.body();){
                this.checkError(execute, request, responseBody);
            }
        }

        private void checkError(Response execute, Request request, ResponseBody responseBody) throws IOException {
            int code = execute.code();
            switch (code) {
                case 404: {
                    throw new NoDataFoundException(execute, request, responseBody);
                }
                case 401: {
                    throw new UnauthorizedException(execute, request, responseBody);
                }
                case 409: {
                    throw new DataAlreadyExistsException(execute, request, responseBody);
                }
            }
            throw new CwmsHttpResponseException(execute, request, responseBody);
        }

        private Timer createTimer() {
            if (!CwmsHttpClientMetrics.isMetricsEnabled()) {
                return new NoOpTimer();
            }
            Metrics metrics = CwmsHttpClientMetrics.createMetrics(Objects.toString(HttpRequestBuilderImpl.this.httpUrl.resolve(HttpRequestBuilderImpl.this.endpoint)));
            Timer timer = metrics.createTimer();
            Properties metricsProperties = new Properties();
            metricsProperties.putAll((Map<?, ?>)HttpRequestBuilderImpl.this.queryParameters);
            metricsProperties.putAll((Map<?, ?>)HttpRequestBuilderImpl.this.queryHeaders);
            timer.setMetricProperties(metricsProperties);
            return timer;
        }

        HttpRequestBuilderImpl getInstance() {
            return HttpRequestBuilderImpl.this.getCurrentInstance();
        }
    }

    private class HttpRequiredMediaTypeImpl
    implements HttpRequestMediaType {
        private HttpRequiredMediaTypeImpl() {
        }

        @Override
        public HttpRequestExecutor withMediaType(String type) {
            HttpRequestBuilderImpl.this.mediaType = type;
            return new HttpRequestExecutorImpl();
        }
    }

    private class HttpPutRequestImpl
    implements HttpPutRequest {
        private HttpPutRequestImpl() {
        }

        @Override
        public HttpRequestMediaType withBody(String putBody) {
            HttpRequestBuilderImpl.this.body = putBody;
            return new HttpRequiredMediaTypeImpl();
        }
    }

    private class HttpPostRequestImpl
    implements HttpPostRequest {
        private HttpPostRequestImpl() {
        }

        @Override
        public HttpRequestMediaType withBody(String postBody) {
            HttpRequestBuilderImpl.this.body = postBody;
            return new HttpRequiredMediaTypeImpl();
        }
    }
}

