/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.cwms.http.client;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.cwms.http.client.CwmsHttpLoggingInterceptor;
import mil.army.usace.hec.cwms.http.client.auth.OAuth2Token;
import mil.army.usace.hec.cwms.http.client.auth.OAuth2TokenProvider;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

final class OAuth2TokenInterceptor
implements Interceptor {
    private static final Logger LOGGER = Logger.getLogger(OAuth2TokenInterceptor.class.getName());
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private final OAuth2TokenProvider tokenProvider;

    OAuth2TokenInterceptor(OAuth2TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
        CwmsHttpLoggingInterceptor.getInstance().redactHeader(AUTHORIZATION_HEADER);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        OAuth2Token oauth2Token = this.tokenProvider.getToken();
        if (oauth2Token == null) {
            throw new IOException("Authentication failed: No token retrieved from " + OAuth2TokenProvider.class.getName());
        }
        String accessToken = oauth2Token.getAccessToken();
        if (accessToken == null || accessToken.isEmpty()) {
            throw new IOException("Authentication failed: No access token present");
        }
        LOGGER.log(Level.FINEST, "Authenticating request with OAuth2 Token");
        Request request = this.newRequestWithAccessTokenAsHeader(chain.request(), oauth2Token);
        return chain.proceed(request);
    }

    Request newRequestWithAccessTokenAsHeader(Request request, OAuth2Token oauth2Token) {
        return request.newBuilder().header(AUTHORIZATION_HEADER, oauth2Token.getTokenType() + " " + oauth2Token.getAccessToken()).build();
    }
}

