/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.cwms.http.client;

import java.util.List;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import mil.army.usace.hec.cwms.http.client.ApiConnectionInfo;
import mil.army.usace.hec.cwms.http.client.OkHttpClientInstance;
import mil.army.usace.hec.cwms.http.client.SslSocketData;
import okhttp3.CookieJar;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

final class OkHttpClientFactory {
    private OkHttpClientFactory() {
        throw new AssertionError((Object)"Utility class");
    }

    static OkHttpClient buildOkHttpClient(ApiConnectionInfo apiConnectionInfo) {
        OkHttpClient.Builder builder = OkHttpClientInstance.getInstance().newBuilder();
        Optional<SslSocketData> optionalSslSocketData = apiConnectionInfo.sslSocketData();
        if (optionalSslSocketData.isPresent()) {
            SslSocketData sslSocketData = optionalSslSocketData.get();
            builder = builder.sslSocketFactory(sslSocketData.getSslSocketFactory(), sslSocketData.getX509TrustManager());
        }
        List<Interceptor> interceptors = apiConnectionInfo.interceptors();
        for (Interceptor interceptor : interceptors) {
            builder = builder.addInterceptor(interceptor);
        }
        builder = apiConnectionInfo.authenticator().map(arg_0 -> ((OkHttpClient.Builder)builder).authenticator(arg_0)).orElse(builder);
        CookieJar cookieJar = apiConnectionInfo.cookieJar().orElse(CookieJar.NO_COOKIES);
        Optional<HostnameVerifier> hostnameVerifier = apiConnectionInfo.hostnameVerifier();
        if (hostnameVerifier.isPresent()) {
            builder.hostnameVerifier(hostnameVerifier.get());
        }
        return builder.cookieJar(cookieJar).build();
    }
}

