/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.cwms.http.client;

import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.cwms.http.client.CwmsHttpLoggingInterceptor;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

final class OkHttpClientInstance {
    private static final Logger LOGGER = Logger.getLogger(OkHttpClientInstance.class.getName());
    static final String CALL_TIMEOUT_PROPERTY_KEY = "cwms.http.client.calltimeout.seconds";
    static final Duration CALL_TIMEOUT_PROPERTY_DEFAULT = Duration.ofSeconds(0L);
    static final String CONNECT_TIMEOUT_PROPERTY_KEY = "cwms.http.client.connecttimeout.seconds";
    static final Duration CONNECT_TIMEOUT_PROPERTY_DEFAULT = Duration.ofSeconds(5L);
    static final String READ_TIMEOUT_PROPERTY_KEY = "cwms.http.client.readtimeout.seconds";
    static final Duration READ_TIMEOUT_PROPERTY_DEFAULT = Duration.ofMinutes(5L);
    static final String WRITE_TIMEOUT_PROPERTY_KEY = "cwms.http.client.writetimeout.seconds";
    static final Duration WRITE_TIMEOUT_PROPERTY_DEFAULT = Duration.ofMinutes(1L);
    private static final CwmsHttpLoggingInterceptor LOGGING_INTERCEPTOR = CwmsHttpLoggingInterceptor.getInstance();
    private static final OkHttpClient INSTANCE = OkHttpClientInstance.createClient();

    private OkHttpClientInstance() {
        throw new AssertionError((Object)"Singleton utility class, cannot instantiate");
    }

    static OkHttpClient createClient() {
        return new OkHttpClient.Builder().callTimeout(OkHttpClientInstance.getCallTimeout()).connectTimeout(OkHttpClientInstance.getConnectTimeout()).readTimeout(OkHttpClientInstance.getReadTimeout()).writeTimeout(OkHttpClientInstance.getWriteTimeout()).addInterceptor((Interceptor)LOGGING_INTERCEPTOR).build();
    }

    private static Duration getReadTimeout() {
        return OkHttpClientInstance.getDurationProperty(READ_TIMEOUT_PROPERTY_KEY, READ_TIMEOUT_PROPERTY_DEFAULT);
    }

    private static Duration getWriteTimeout() {
        return OkHttpClientInstance.getDurationProperty(WRITE_TIMEOUT_PROPERTY_KEY, WRITE_TIMEOUT_PROPERTY_DEFAULT);
    }

    private static Duration getConnectTimeout() {
        return OkHttpClientInstance.getDurationProperty(CONNECT_TIMEOUT_PROPERTY_KEY, CONNECT_TIMEOUT_PROPERTY_DEFAULT);
    }

    private static Duration getCallTimeout() {
        return OkHttpClientInstance.getDurationProperty(CALL_TIMEOUT_PROPERTY_KEY, CALL_TIMEOUT_PROPERTY_DEFAULT);
    }

    private static Duration getDurationProperty(String timeoutPropertyKey, Duration timeoutPropertyDefault) {
        String writeTimeoutPropertyValue = System.getProperty(timeoutPropertyKey);
        Duration writeTimeout = timeoutPropertyDefault;
        if (writeTimeoutPropertyValue == null) {
            LOGGER.log(Level.FINE, () -> "Setting " + timeoutPropertyKey + " is not set in system properties. Defaulting to " + timeoutPropertyDefault);
        } else {
            LOGGER.log(Level.FINE, () -> "Setting " + timeoutPropertyKey + " read from system properties as " + writeTimeoutPropertyValue);
            writeTimeout = Duration.parse(writeTimeoutPropertyValue);
        }
        return writeTimeout;
    }

    static OkHttpClient getInstance() {
        return INSTANCE;
    }
}

