/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.cwms.http.client;

import java.io.IOException;
import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import okhttp3.Cookie;
import okhttp3.HttpUrl;

public final class PreferencesBackedCookieStore
implements CookieStore {
    private static final Logger LOGGER = Logger.getLogger(PreferencesBackedCookieStore.class.getName());
    private static final String DOMAIN_COOKIE_DELIMITER = " | ";
    private static final String URI_KEY = "URI";
    private final Preferences preferences;
    private final CookieManager cookieManager;

    public PreferencesBackedCookieStore(Preferences preferences) {
        this.preferences = preferences.node("cwms_http_client_cookies");
        this.cookieManager = new CookieManager();
        this.restoreCookiesFromPreferences();
        Runtime.getRuntime().addShutdownHook(new Thread(this::writeCookiesToPreferences));
    }

    @Override
    public void add(URI uri, HttpCookie cookie) {
        this.cookieManager.getCookieStore().add(uri, cookie);
    }

    @Override
    public List<HttpCookie> get(URI uri) {
        return this.cookieManager.getCookieStore().get(uri);
    }

    @Override
    public List<HttpCookie> getCookies() {
        return this.cookieManager.getCookieStore().getCookies();
    }

    @Override
    public List<URI> getURIs() {
        return this.cookieManager.getCookieStore().getURIs();
    }

    @Override
    public boolean remove(URI uri, HttpCookie cookie) {
        return this.cookieManager.getCookieStore().remove(uri, cookie);
    }

    @Override
    public boolean removeAll() {
        return this.cookieManager.getCookieStore().removeAll();
    }

    private void restoreCookiesFromPreferences() {
        try {
            Map<URI, List<String>> uriToCookie = this.extractCookiesFromPreferences();
            for (Map.Entry<URI, List<String>> entry : uriToCookie.entrySet()) {
                try {
                    HashMap<String, List<String>> storingCookies = new HashMap<String, List<String>>();
                    storingCookies.put("Set-Cookie", entry.getValue());
                    this.cookieManager.put(entry.getKey(), storingCookies);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e, () -> "Unable to store preference cookies to cookie manager for URL: " + entry.getKey());
                }
            }
        }
        catch (BackingStoreException e) {
            LOGGER.log(Level.CONFIG, e, () -> "Unable to obtain cookies stored in preferences at node: " + this.preferences.absolutePath());
        }
    }

    private Map<URI, List<String>> extractCookiesFromPreferences() throws BackingStoreException {
        HashMap<URI, List<String>> uriToCookie = new HashMap<URI, List<String>>();
        for (String child : this.preferences.childrenNames()) {
            Preferences node = this.preferences.node(child);
            String uriAddress = node.get(URI_KEY, "");
            URI uri = URI.create(uriAddress);
            List cookies = uriToCookie.computeIfAbsent(uri, u -> new ArrayList());
            for (String cookieName : node.keys()) {
                if (URI_KEY.equals(cookieName)) continue;
                cookies.add(node.get(cookieName, ""));
            }
        }
        return uriToCookie;
    }

    public void writeCookiesToPreferences() {
        try {
            List<URI> urIs = this.cookieManager.getCookieStore().getURIs();
            for (URI key : urIs) {
                try {
                    for (List<String> value : this.cookieManager.get(key, new HashMap<String, List<String>>()).values()) {
                        this.storeCookiesForUrl(key, value);
                    }
                    if (!key.toString().contains("http:")) continue;
                    URI https = URI.create(key.toString().replace("http:", "https:"));
                    for (List<String> value : this.cookieManager.get(https, new HashMap<String, List<String>>()).values()) {
                        this.storeCookiesForUrl(https, value);
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e, () -> "Unable to obtain cookies for url: " + key);
                }
            }
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            LOGGER.log(Level.WARNING, e, () -> "Unable to write cookies to preferences node: " + this.preferences.absolutePath());
        }
    }

    private void storeCookiesForUrl(URI key, List<String> value) {
        Preferences node = this.preferences.node(key.getHost());
        node.put(URI_KEY, key.toString());
        for (String cookie : value) {
            Cookie parse;
            HttpUrl httpUrl = HttpUrl.get((URI)key);
            if (httpUrl == null || (parse = Cookie.parse((HttpUrl)httpUrl, (String)cookie)) == null) continue;
            node.put((parse.domain() + DOMAIN_COOKIE_DELIMITER + parse.name()).toLowerCase(), cookie);
        }
    }
}

