/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.cwms.http.client;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.cwms.http.client.CwmsHttpLoggingInterceptor;
import mil.army.usace.hec.cwms.http.client.auth.SimpleAuthKeyProvider;
import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

final class SimpleAuthHeaderAuthenticator
implements Authenticator {
    private static final Logger LOGGER = Logger.getLogger(SimpleAuthHeaderAuthenticator.class.getName());
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private final AtomicBoolean _alreadyRetried = new AtomicBoolean(false);
    private final SimpleAuthKeyProvider keyProvider;

    SimpleAuthHeaderAuthenticator(SimpleAuthKeyProvider keyProvider) {
        this.keyProvider = keyProvider;
        CwmsHttpLoggingInterceptor.getInstance().redactHeader(AUTHORIZATION_HEADER);
    }

    public Request authenticate(Route route, Response response) throws IOException {
        LOGGER.log(Level.FINE, () -> "Authentication required for: " + response.request().url() + " attempting acquiring authorization key");
        String authorizationKey = this.keyProvider.getAuthorizationKey();
        if (authorizationKey == null) {
            throw new IOException("No Authorization key retrieved from " + this.keyProvider.getClass().getName());
        }
        if (authorizationKey.equals(response.request().header(AUTHORIZATION_HEADER))) {
            LOGGER.log(Level.FINE, () -> "Re-authentication attempt failed. Provider returned the same key as the original request. \nRequsted URL:" + response.request().url() + "\nError Code: " + response.code());
            return null;
        }
        LOGGER.log(Level.FINE, () -> "Authentication required for: " + response.request().url() + " acquired authorization key and creating a new request");
        return this.newRequestWithAccessTokenAsHeader(response, authorizationKey);
    }

    Request newRequestWithAccessTokenAsHeader(Response response, String authorizationKey) {
        return response.request().newBuilder().header(AUTHORIZATION_HEADER, authorizationKey).build();
    }
}

