/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.cwms.http.client;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.cwms.http.client.CwmsHttpLoggingInterceptor;
import mil.army.usace.hec.cwms.http.client.auth.SimpleAuthKeyProvider;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

final class SimpleAuthHeaderInterceptor
implements Interceptor {
    private static final Logger LOGGER = Logger.getLogger(SimpleAuthHeaderInterceptor.class.getName());
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private final SimpleAuthKeyProvider keyProvider;

    SimpleAuthHeaderInterceptor(SimpleAuthKeyProvider keyProvider) {
        this.keyProvider = keyProvider;
        CwmsHttpLoggingInterceptor.getInstance().redactHeader(AUTHORIZATION_HEADER);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String authorizationKey = this.keyProvider.getAuthorizationKey();
        if (authorizationKey == null) {
            throw new IOException("Authentication failed: No authorization key retrieved from " + this.keyProvider.getClass().getName());
        }
        LOGGER.log(Level.FINEST, "Authenticating request with Authorization Key Token");
        Request request = this.newRequestWithAccessTokenAsHeader(chain.request(), authorizationKey);
        return chain.proceed(request);
    }

    Request newRequestWithAccessTokenAsHeader(Request request, String authorizationKey) {
        return request.newBuilder().header(AUTHORIZATION_HEADER, authorizationKey).build();
    }
}

