/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.cwms.http.client.auth;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.X509KeyManager;
import mil.army.usace.hec.cwms.http.client.auth.CacCertificateException;
import mil.army.usace.hec.cwms.http.client.auth.CacKeyManagerUtil;

final class CacKeyManager
implements X509KeyManager {
    private static final Logger LOGGER = Logger.getLogger(CacKeyManager.class.getName());
    private final X509KeyManager delegate;
    private final KeyStore keystore;
    private final String certificateAlias;

    CacKeyManager(X509KeyManager delegate, KeyStore keystore, String certificateAlias) {
        this.delegate = delegate;
        this.keystore = keystore;
        this.certificateAlias = certificateAlias;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.delegate.getClientAliases(keyType, issuers);
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        String retVal = null;
        if (this.certificateAlias != null) {
            retVal = this.getPivCertificate(new String[]{this.certificateAlias});
        }
        if (retVal == null) {
            this.delegate.chooseClientAlias(keyTypes, issuers, socket);
            if (keyTypes != null) {
                for (String keyType : keyTypes) {
                    String[] clientAliases = this.getClientAliases(keyType, issuers);
                    if (clientAliases == null || clientAliases.length <= 0) continue;
                    retVal = this.getPivCertificate(clientAliases);
                    break;
                }
            }
        }
        return retVal;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.delegate.getServerAliases(keyType, issuers);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.delegate.chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.delegate.getCertificateChain(alias);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.delegate.getPrivateKey(alias);
    }

    private String getPivCertificate(String[] aliases) {
        String retVal = aliases[0];
        for (String alias : aliases) {
            try {
                Certificate cr = this.keystore.getCertificate(alias);
                if (!(cr instanceof X509Certificate) || !CacKeyManagerUtil.isPivCertificate((X509Certificate)cr)) continue;
                retVal = alias;
                break;
            }
            catch (KeyStoreException | CacCertificateException e) {
                LOGGER.log(Level.FINE, "Unable to authorize certificate for CWBI Authentication", e);
            }
        }
        return retVal;
    }
}

