/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.cwms.http.client.auth;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import mil.army.usace.hec.cwms.http.client.auth.CacCertificateException;
import mil.army.usace.hec.cwms.http.client.auth.CacKeyManager;

public final class CacKeyManagerUtil {
    static final Pattern EDIPI_PATTERN = Pattern.compile("\\d{10}@", 2);
    private static final Logger LOGGER = Logger.getLogger(CacKeyManagerUtil.class.getName());

    private CacKeyManagerUtil() {
        throw new AssertionError((Object)"Utility class");
    }

    public static KeyManager createKeyManager() throws CacCertificateException {
        return CacKeyManagerUtil.getKeyManagerFromWindowsKeyStore(null);
    }

    public static KeyManager createKeyManager(String certificateAlias) throws CacCertificateException {
        return CacKeyManagerUtil.getKeyManagerFromWindowsKeyStore(certificateAlias);
    }

    private static CacKeyManager getKeyManagerFromWindowsKeyStore(String certificateAlias) throws CacCertificateException {
        try {
            KeyManager[] kms;
            KeyStore keystore = KeyStore.getInstance("WINDOWS-MY");
            keystore.load(null, null);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keystore, null);
            for (KeyManager km : kms = kmf.getKeyManagers()) {
                if (!(km instanceof X509KeyManager)) continue;
                return new CacKeyManager((X509KeyManager)km, keystore, certificateAlias);
            }
            throw new CacCertificateException("Failed to get X509KeyManager from Windows OS");
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new CacCertificateException("Failed to get X509KeyManager from Windows OS", e);
        }
    }

    public static List<String> getCertificateAliases() {
        TreeSet<String> aliases = new TreeSet<String>();
        try {
            KeyStore keystore = KeyStore.getInstance("WINDOWS-MY");
            keystore.load(null, null);
            Enumeration<String> keystoreAliases = keystore.aliases();
            while (keystoreAliases.hasMoreElements()) {
                String alias = keystoreAliases.nextElement();
                Certificate[] certificateChain = keystore.getCertificateChain(alias);
                if (certificateChain == null || certificateChain.length <= 1 || !(certificateChain[0] instanceof X509Certificate) || !CacKeyManagerUtil.isPivCertificate((X509Certificate)certificateChain[0])) continue;
                aliases.add(alias);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException | CacCertificateException e) {
            LOGGER.log(Level.WARNING, "Error reading certificates from WINDOWS-MY keystore", e);
        }
        return new ArrayList<String>(aliases);
    }

    public static boolean isPivCertificate(X509Certificate cr) throws CacCertificateException {
        try {
            Collection<List<?>> subjectAlternativeNames = cr.getSubjectAlternativeNames();
            if (subjectAlternativeNames == null) {
                return false;
            }
            for (List<?> subjectAlternativeName : subjectAlternativeNames) {
                String edipiSan;
                Object bytes = subjectAlternativeName.get(1);
                if (!(bytes instanceof byte[])) continue;
                String encoded = new String((byte[])bytes);
                int edipiLengh = 10;
                int index = encoded.indexOf("@mil");
                if (index < edipiLengh) {
                    index = encoded.indexOf("@rma");
                }
                if (index < edipiLengh || !EDIPI_PATTERN.matcher(edipiSan = encoded.substring(index - edipiLengh, index + 1)).matches()) continue;
                return true;
            }
            return false;
        }
        catch (CertificateParsingException e) {
            throw new CacCertificateException("Unable to parse X509 Certificate", e);
        }
    }
}

