/*
 * Decompiled with CFR 0.152.
 */
package hec.serversuite;

import hec.serversuite.ClientCacException;
import hec.serversuite.CwmsClientRmiSocketFactory;
import hec.serversuite.CwmsClientTrustManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.rmi.server.RMISocketFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import mil.army.usace.hec.cwms.http.client.auth.CacCertificateException;
import mil.army.usace.hec.cwms.http.client.auth.CacKeyManagerUtil;

public final class CwmsCacUtil {
    public static final String SSL_CONTEXT_PROTOCOL_PROPERTY = "cwms.ssl.context.protocol";
    public static final String SSL_CONTEXT_PROTOCOL_DEFAULT = "TLS";
    private static final Logger LOGGER = Logger.getLogger(CwmsCacUtil.class.getName());
    private static final String ALT_KEY_STORE_KEY = "javax.net.ssl.cwms.keyStore";
    private static final String ALT_KEY_STORE_PASS = "javax.net.ssl.cwms.keyStorePasswd";
    private static final String ALT_KEY_STORE_TYPE = "javax.net.ssl.cwms.keyStoreType";
    private static SSLContext _sslContext;
    private static String _certificateAlias;
    private static final Set<String> WINDOWS_CERTIFICATE_ALIASES;

    private CwmsCacUtil() {
        throw new AssertionError((Object)"Utility class");
    }

    public static synchronized SSLContext getSslContext(String certificateAlias) throws ClientCacException {
        if (_sslContext == null || certificateAlias != null && !Objects.equals(_certificateAlias, certificateAlias)) {
            _sslContext = CwmsCacUtil.createSslContext(certificateAlias);
            _certificateAlias = certificateAlias;
        }
        return _sslContext;
    }

    private static SSLContext createSslContext(String certificateAlias) throws ClientCacException {
        try {
            SSLContext sc = SSLContext.getInstance(System.getProperty(SSL_CONTEXT_PROTOCOL_PROPERTY, SSL_CONTEXT_PROTOCOL_DEFAULT));
            sc.init(new KeyManager[]{CwmsCacUtil.getKeyManager(certificateAlias)}, new TrustManager[]{CwmsClientTrustManager.getTrustManager()}, null);
            return sc;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            throw new ClientCacException("Error building SSLSocketFactory for CWMS servers with certificate alias: " + certificateAlias, ex);
        }
    }

    public static SSLSocketFactory getSslSocketFactory(String certificateAlias) throws ClientCacException {
        return CwmsCacUtil.getSslContext(certificateAlias).getSocketFactory();
    }

    public static void initRmiSocketFactory(String certificateAlias) throws ClientCacException {
        CwmsClientRmiSocketFactory instance = CwmsClientRmiSocketFactory.getInstance(certificateAlias);
        if (RMISocketFactory.getSocketFactory() == null) {
            try {
                RMISocketFactory.setSocketFactory(instance);
            }
            catch (IOException | RuntimeException ex) {
                throw new ClientCacException("Error building SSLSocketFactory for CWMS servers with certificate alias: " + certificateAlias, ex);
            }
        }
    }

    public static KeyManager getKeyManager(String certificateAlias) throws KeyStoreException {
        try {
            KeyManager keyManager;
            if (System.getProperty(ALT_KEY_STORE_KEY) != null) {
                String property = System.getProperty(ALT_KEY_STORE_PASS);
                char[] ksPasswd = null;
                if (property != null) {
                    ksPasswd = property.toCharArray();
                }
                KeyStore keyStore = CwmsCacUtil.getAlternateKeystore(ksPasswd);
                KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                factory.init(keyStore, ksPasswd);
                keyManager = factory.getKeyManagers()[0];
            } else {
                keyManager = CacKeyManagerUtil.createKeyManager((String)certificateAlias);
            }
            return keyManager;
        }
        catch (IOException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | CacCertificateException e) {
            throw new KeyStoreException("Unable to initialize keystore with certificate alias: " + certificateAlias, e);
        }
    }

    private static KeyStore getAlternateKeystore(char[] ksPasswd) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        String ksType = System.getProperty(ALT_KEY_STORE_TYPE, "JKS");
        String ksFile = System.getProperty(ALT_KEY_STORE_KEY);
        KeyStore keyStore = KeyStore.getInstance(ksType);
        try (FileInputStream fp = new FileInputStream(ksFile);){
            keyStore.load(fp, ksPasswd);
        }
        return keyStore;
    }

    public static synchronized CompletableFuture<Set<String>> getCertificateAliases() {
        return CompletableFuture.supplyAsync(() -> {
            if (System.getProperty(ALT_KEY_STORE_KEY) != null) {
                return CwmsCacUtil.getAlternateKeystoreAliases();
            }
            if (WINDOWS_CERTIFICATE_ALIASES.isEmpty()) {
                WINDOWS_CERTIFICATE_ALIASES.addAll(CacKeyManagerUtil.getCertificateAliases());
            }
            return WINDOWS_CERTIFICATE_ALIASES;
        });
    }

    private static Set<String> getAlternateKeystoreAliases() {
        TreeSet<String> aliases = new TreeSet<String>();
        try {
            String property = System.getProperty(ALT_KEY_STORE_PASS);
            char[] ksPasswd = null;
            if (property != null) {
                ksPasswd = property.toCharArray();
            }
            KeyStore keyStore = CwmsCacUtil.getAlternateKeystore(ksPasswd);
            Enumeration<String> bypassAlias = keyStore.aliases();
            while (bypassAlias.hasMoreElements()) {
                aliases.add(bypassAlias.nextElement());
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            LOGGER.log(Level.WARNING, "Error reading alias information from CWMS client certificate", ex);
        }
        return aliases;
    }

    static {
        WINDOWS_CERTIFICATE_ALIASES = new TreeSet<String>();
    }
}

