/*
 * Decompiled with CFR 0.152.
 */
package hec.serversuite;

import com.google.common.flogger.FluentLogger;
import hec.serversuite.ClientCacException;
import hec.serversuite.CwmsCacUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import rma.net.HostNameIPChecker;

public final class CwmsClientRmiSocketFactory
extends RMISocketFactory {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static final boolean ENCRYPT_SERVER = Boolean.getBoolean("cwms.rmi.client.socketfactory.encrypt.server");
    private static final boolean ENCRYPT_LOCALHOST = Boolean.getBoolean("cwms.rmi.client.socketfactory.encrypt.localhost");
    private static CwmsClientRmiSocketFactory socketFactory;
    private final Map<String, Boolean> _localHostCheck = new ConcurrentHashMap<String, Boolean>();
    private SSLContext _sslContext;

    private CwmsClientRmiSocketFactory(SSLContext sslContext) {
        this._sslContext = sslContext;
    }

    public static synchronized CwmsClientRmiSocketFactory getInstance() throws ClientCacException {
        return CwmsClientRmiSocketFactory.getInstance(CwmsCacUtil.getSslContext(null));
    }

    public static synchronized CwmsClientRmiSocketFactory getInstance(String certificateAlias) throws ClientCacException {
        return CwmsClientRmiSocketFactory.getInstance(CwmsCacUtil.getSslContext(certificateAlias));
    }

    public static synchronized CwmsClientRmiSocketFactory getInstance(SSLContext sc) {
        if (socketFactory == null) {
            socketFactory = new CwmsClientRmiSocketFactory(sc);
        }
        CwmsClientRmiSocketFactory.socketFactory._sslContext = sc;
        return socketFactory;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        ((FluentLogger.Api)LOGGER.atFinest()).log("Create socket: " + host + ":" + port);
        if (ENCRYPT_LOCALHOST || !this._localHostCheck.computeIfAbsent(host, HostNameIPChecker::isLocalhost).booleanValue()) {
            return this._sslContext.getSocketFactory().createSocket(host, port);
        }
        return RMISocketFactory.getDefaultSocketFactory().createSocket(host, port);
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        ((FluentLogger.Api)LOGGER.atFinest()).log("Create server socket at port: " + port);
        if (ENCRYPT_SERVER) {
            return this._sslContext.getServerSocketFactory().createServerSocket(port);
        }
        return RMISocketFactory.getDefaultSocketFactory().createServerSocket(port);
    }
}

