/*
 * Decompiled with CFR 0.152.
 */
package hec.serversuite;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

public final class CwmsClientTrustManager
implements X509TrustManager {
    private static final Logger LOGGER = Logger.getLogger(CwmsClientTrustManager.class.getName());
    private static X509TrustManager _trustManager;
    private final TrustManagerFactory _trustManagerFactory;

    private CwmsClientTrustManager(TrustManagerFactory trustManagerFactory) {
        this._trustManagerFactory = trustManagerFactory;
    }

    public static X509TrustManager getTrustManager() throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        if (_trustManager == null) {
            _trustManager = CwmsClientTrustManager.createTrustManager();
        }
        return _trustManager;
    }

    private static X509TrustManager createTrustManager() throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore trustStore = KeyStore.getInstance(System.getProperty("javax.net.ssl.cwms.trustStoreType", "JKS"));
        String trustStorePass = System.getProperty("javax.net.ssl.cwms.trustStorePass");
        String trustStoreFileKey = "javax.net.ssl.cwms.trustStore";
        String property = System.getProperty(trustStoreFileKey, "");
        try (FileInputStream fp = new FileInputStream(property);){
            trustStore.load(fp, Optional.ofNullable(trustStorePass).map(String::toCharArray).orElse(null));
        }
        catch (IOException ex) {
            throw new KeyStoreException("Failed to create X509TrustManager, could not read trust store file: " + property + " specified by property: " + trustStoreFileKey, ex);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        return new CwmsClientTrustManager(trustManagerFactory);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        for (TrustManager trustManager : this._trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            try {
                ((X509TrustManager)trustManager).checkClientTrusted(x509Certificates, s);
            }
            catch (CertificateException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e, () -> "Certificate chain not part of trusted certificates for this JRE: " + Arrays.toString(x509Certificates));
                } else {
                    LOGGER.log(Level.WARNING, () -> "Certificate chain not part of trusted certificates for this JRE: " + Arrays.stream(x509Certificates).map(X509Certificate::getSubjectX500Principal).map(X500Principal::getName).collect(Collectors.joining(",")));
                }
                throw e;
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        for (TrustManager trustManager : this._trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            try {
                ((X509TrustManager)trustManager).checkServerTrusted(x509Certificates, s);
            }
            catch (CertificateException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e, () -> "Certificate chain not part of trusted certificates for this JRE: " + Arrays.toString(x509Certificates));
                } else {
                    LOGGER.log(Level.WARNING, () -> "Certificate chain not part of trusted certificates for this JRE: " + Arrays.stream(x509Certificates).map(X509Certificate::getSubjectX500Principal).map(X500Principal::getName).collect(Collectors.joining(",")));
                }
                throw e;
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return (X509Certificate[])Arrays.stream(this._trustManagerFactory.getTrustManagers()).filter(t -> t instanceof X509TrustManager).map(t -> (X509TrustManager)t).map(X509TrustManager::getAcceptedIssuers).flatMap(Arrays::stream).toArray(X509Certificate[]::new);
    }
}

