/*
 * Decompiled with CFR 0.152.
 */
package hec.serversuite;

import hec.security.UserProfile;
import hec.serversuite.ClientAuthenticationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Pattern;

public interface CwmsLoginClient {
    public UserProfile logIn(String var1, String var2) throws ClientAuthenticationException;

    public UserProfile logOut(UserProfile var1) throws ClientAuthenticationException;

    public boolean isLoggedIn(UserProfile var1) throws ClientAuthenticationException;

    public static boolean versionIsCompatible(String remote) throws IOException {
        String regex;
        block17: {
            regex = System.getProperty("cwms.loginserver.version.regex", "");
            if (regex.isEmpty()) {
                try (InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("hec/serversuite/cwms_loginserver_version_regex.txt");){
                    if (resourceAsStream == null) break block17;
                    try (InputStreamReader inputStreamReader = new InputStreamReader(resourceAsStream);
                         BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                        regex = bufferedReader.readLine();
                    }
                }
            }
        }
        Pattern compile = Pattern.compile(regex);
        return compile.matcher(remote).matches();
    }
}

