/*
 * Decompiled with CFR 0.152.
 */
package hec.serversuite;

import com.google.common.flogger.FluentLogger;
import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public final class CwmsServerRmiSocketFactory
extends RMISocketFactory
implements Serializable {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static final long serialVersionUID = 4953267006397545251L;
    private final transient SSLSocketFactory _socketFactory;
    private final transient SSLServerSocketFactory _serverSocketFactory;
    private final transient SSLContext _sslContext;

    public CwmsServerRmiSocketFactory(SSLContext sslContext) {
        this._sslContext = sslContext;
        this._socketFactory = this._sslContext.getSocketFactory();
        this._serverSocketFactory = this._sslContext.getServerSocketFactory();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        ((FluentLogger.Api)LOGGER.atFinest()).log("Create socket: " + host + ":" + port);
        if (this._socketFactory != null) {
            return this._socketFactory.createSocket(host, port);
        }
        return RMISocketFactory.getSocketFactory().createSocket(host, port);
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        if (this._serverSocketFactory != null) {
            ((FluentLogger.Api)LOGGER.atFinest()).log("Create server socket at port: " + port);
            SSLServerSocket serverSocket = (SSLServerSocket)this._serverSocketFactory.createServerSocket(port);
            String supportedProtocols = System.getProperty("cwms.servers.rmi.socket.protocols", "TLSv1.3,TLSv1.2");
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atFine()).atMostEvery(1, TimeUnit.DAYS)).log("RMI Socket factory configured protocols: " + supportedProtocols);
            serverSocket.setEnabledProtocols(supportedProtocols.split(","));
            serverSocket.setEnabledCipherSuites(serverSocket.getSupportedCipherSuites());
            serverSocket.setNeedClientAuth(true);
            return serverSocket;
        }
        return RMISocketFactory.getSocketFactory().createServerSocket(port);
    }

    public SSLContext getSSLContext() {
        return this._sslContext;
    }
}

