/*
 * Decompiled with CFR 0.152.
 */
package hec.serversuite;

import hec.appInterface.FileOpener;
import hec.db.DataAccessFactory;
import hec.lang.LoginException;
import hec.security.UserProfile;
import hec.serversuite.ClientAuthenticationException;
import hec.serversuite.ServerSuiteBuilder;
import hec.serversuite.data.CwmsAuthenticationSource;
import hec.serversuite.data.ServerLoginState;
import java.util.HashSet;
import java.util.Set;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.csinterface.RMIScheduler;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.csinterface.RmiLogin;
import rma.util.lookup.Lookups;

public interface ServerSuite {
    public static ServerSuite getServerSuite(CwmsAuthenticationSource cwmsAuthenticationSource) throws ClientAuthenticationException {
        ServerSuiteBuilder lookup = (ServerSuiteBuilder)Lookups.forPath((String)cwmsAuthenticationSource.getLookup()).lookup(ServerSuiteBuilder.class);
        if (lookup == null) {
            throw new ClientAuthenticationException("Application is unable to connect to data source of type: " + cwmsAuthenticationSource.getDescription());
        }
        return lookup.build(cwmsAuthenticationSource);
    }

    public void login(char[] var1, char[] var2, String var3) throws LoginException;

    public void login(String var1) throws LoginException;

    public void logoff() throws LoginException;

    public void setLoginState(ServerLoginState var1);

    public CwmsAuthenticationSource getServer();

    public UserProfile getUserProfile();

    public ServerLoginState getState();

    public String getCWMSHome();

    public RmiFileManager getFileManager();

    public FileOpener getRemoteFileOpener();

    public RmiLogin getLoginServer();

    public DataAccessFactory getDataAccessFactory() throws ClientAuthenticationException;

    public DSSManager getDSSManager();

    public RMIScheduler getScheduler();

    default public Set<String> getLoginListenerUrls() {
        return new HashSet<String>();
    }
}

