/*
 * Decompiled with CFR 0.152.
 */
package hec.serversuite;

import hec.appInterface.FileOpener;
import hec.db.DataAccessFactory;
import hec.lang.LoginException;
import hec.security.UserProfile;
import hec.serversuite.ClientAuthenticationException;
import hec.serversuite.CwmsLoginException;
import hec.serversuite.ServerSuite;
import hec.serversuite.ServerSuiteFactory;
import hec.serversuite.ServerSuiteListener;
import hec.serversuite.data.CwmsAuthenticationSource;
import hec.serversuite.data.CwmsLoginUtil;
import hec.serversuite.data.ServerInfo;
import hec.serversuite.data.ServerLoginState;
import java.awt.Image;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.rmi.csinterface.ClientServerUtil;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.csinterface.RMIScheduler;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.csinterface.RmiLogin;
import rma.services.annotations.ServiceProvider;
import rma.util.lookup.Lookup;
import rma.util.lookup.Lookups;

public final class ServerSuiteUtil {
    private static final Logger LOGGER = Logger.getLogger(ServerSuiteUtil.class.getName());
    private static Image image = null;
    private static ServerSuiteFactory factoryInstance = null;
    private static boolean _displayExceptions = true;

    private ServerSuiteUtil() {
        throw new AssertionError((Object)"utility class");
    }

    public static synchronized ServerSuiteFactory getFactory() {
        if (factoryInstance != null) {
            return factoryInstance;
        }
        Lookup lookup = Lookups.forPath((String)"hec/login/ServerSuiteFactory");
        Collection factories = lookup.lookupAll(ServerSuiteFactory.class);
        if (!factories.isEmpty()) {
            factoryInstance = (ServerSuiteFactory)factories.iterator().next();
        }
        return factoryInstance;
    }

    public static ServerSuite login(String appName, boolean useLocal) throws LoginException {
        return ServerSuiteUtil.login(appName, null, useLocal, useLocal);
    }

    public static ServerSuite login(String appName, CwmsAuthenticationSource cwmsAuthenticationSource, boolean useLocal) throws LoginException {
        return ServerSuiteUtil.login(appName, cwmsAuthenticationSource, useLocal, useLocal);
    }

    public static ServerSuite login(String appName, CwmsAuthenticationSource cwmsAuthenticationSource, boolean useLocal, boolean localOnCancel) throws LoginException {
        return ServerSuiteUtil.login(appName, cwmsAuthenticationSource, useLocal, localOnCancel, true);
    }

    public static ServerSuite login(String appName, CwmsAuthenticationSource cwmsAuthenticationSource, boolean useLocal, boolean localOnCancel, boolean bLoginDlg) throws LoginException {
        ServerSuiteFactory factory = ServerSuiteUtil.getFactory();
        if (factory == null) {
            throw new LoginException("No Server Suite Factory implementation found at runtime. Unable to log into CWMS servers");
        }
        if (!factory.isLoggedIn(cwmsAuthenticationSource)) {
            return factory.login(appName, cwmsAuthenticationSource, useLocal, localOnCancel, bLoginDlg);
        }
        return factory.getInstance(cwmsAuthenticationSource);
    }

    public static ServerSuite login(String appName, CwmsAuthenticationSource cwmsAuthenticationSource, String userName, char[] password) throws LoginException {
        ServerSuiteFactory factory = ServerSuiteUtil.getFactory();
        if (factory == null) {
            throw new LoginException("No Server Suite Factory implementation found at runtime. Unable to log into CWMS servers");
        }
        if (!factory.isLoggedIn(cwmsAuthenticationSource)) {
            return factory.login(appName, cwmsAuthenticationSource, false, false, false, userName, password);
        }
        return factory.getInstance(cwmsAuthenticationSource);
    }

    public static ServerSuite login(String appName, CwmsAuthenticationSource cwmsAuthenticationSource) throws LoginException {
        return ServerSuiteUtil.login(appName, cwmsAuthenticationSource, true);
    }

    public static void logoff() throws LoginException {
        ServerSuite serverSuite;
        ServerSuiteFactory factory = ServerSuiteUtil.getFactory();
        if (factory != null && (serverSuite = factory.getActiveServerSuite()) != null) {
            serverSuite.logoff();
            factory.reset();
        }
    }

    public static boolean isConnected() {
        ServerLoginState state = ServerSuiteUtil.getState();
        return state == ServerLoginState.LOGGED_IN || state == ServerLoginState.ACL;
    }

    public static String getCWMSHome() {
        ServerSuite serverSuite;
        ServerSuiteFactory factory = ServerSuiteUtil.getFactory();
        if (factory != null && (serverSuite = factory.getActiveServerSuite()) != null) {
            return serverSuite.getCWMSHome();
        }
        return null;
    }

    public static UserProfile getUserProfile() {
        ServerSuite serverSuite;
        ServerSuiteFactory factory = ServerSuiteUtil.getFactory();
        if (factory != null && (serverSuite = factory.getActiveServerSuite()) != null) {
            return serverSuite.getUserProfile();
        }
        return null;
    }

    public static ServerInfo getServer() {
        return Optional.ofNullable(ServerSuiteUtil.getCwmsAuthenticationSource()).map(CwmsAuthenticationSource::getServerInfo).orElse(null);
    }

    public static CwmsAuthenticationSource getCwmsAuthenticationSource() {
        ServerSuite serverSuite;
        ServerSuiteFactory factory = ServerSuiteUtil.getFactory();
        if (factory != null && (serverSuite = factory.getActiveServerSuite()) != null) {
            return serverSuite.getServer();
        }
        return null;
    }

    public static void addListener(ServerSuiteListener listener) {
        ServerSuiteFactory factory = ServerSuiteUtil.getFactory();
        if (factory != null) {
            factory.addListener(listener);
        }
    }

    public static void removeListener(ServerSuiteListener listener) {
        ServerSuiteFactory factory = ServerSuiteUtil.getFactory();
        if (factory != null) {
            factory.removeListener(listener);
        }
    }

    public static DataAccessFactory getDataAccessFactory() {
        ServerSuite serverSuite;
        ServerSuiteFactory factory = ServerSuiteUtil.getFactory();
        if (factory != null && (serverSuite = factory.getActiveServerSuite()) != null) {
            try {
                return serverSuite.getDataAccessFactory();
            }
            catch (ClientAuthenticationException e) {
                LOGGER.log(Level.FINE, "Unable to access CWMS DataAccessFactory", (Throwable)((Object)e));
            }
        }
        return null;
    }

    public static RmiFileManager getFileManager() {
        ServerSuite serverSuite;
        ServerSuiteFactory factory = ServerSuiteUtil.getFactory();
        if (factory != null && (serverSuite = factory.getActiveServerSuite()) != null) {
            return serverSuite.getFileManager();
        }
        return null;
    }

    public static RMIScheduler getScheduler() {
        ServerSuite serverSuite;
        ServerSuiteFactory factory = ServerSuiteUtil.getFactory();
        if (factory != null && (serverSuite = factory.getActiveServerSuite()) != null) {
            return serverSuite.getScheduler();
        }
        return null;
    }

    public static FileOpener getRemoteFileOpener() {
        ServerSuite serverSuite;
        ServerSuiteFactory factory = ServerSuiteUtil.getFactory();
        if (factory != null && (serverSuite = factory.getActiveServerSuite()) != null) {
            return serverSuite.getRemoteFileOpener();
        }
        return null;
    }

    public static DSSManager getDssManager() {
        ServerSuite serverSuite;
        ServerSuiteFactory factory = ServerSuiteUtil.getFactory();
        if (factory != null && (serverSuite = factory.getActiveServerSuite()) != null) {
            return serverSuite.getDSSManager();
        }
        return null;
    }

    public static RmiLogin getLoginServer() {
        ServerSuite serverSuite;
        ServerSuiteFactory factory = ServerSuiteUtil.getFactory();
        if (factory != null && (serverSuite = factory.getActiveServerSuite()) != null) {
            return serverSuite.getLoginServer();
        }
        return null;
    }

    public static ServerLoginState getState() {
        ServerSuite serverSuite;
        ServerSuiteFactory factory = ServerSuiteUtil.getFactory();
        if (factory != null && (serverSuite = factory.getActiveServerSuite()) != null) {
            return serverSuite.getState();
        }
        return ServerLoginState.FAILED;
    }

    public static void setIconImage(Image image) {
        ServerSuiteUtil.image = image;
    }

    public static Image getImageIcon() {
        return image;
    }

    public static ServerSuite getServerSuite() {
        ServerSuite serverSuite = null;
        ServerSuiteFactory factory = ServerSuiteUtil.getFactory();
        if (factory != null) {
            serverSuite = factory.getActiveServerSuite();
        }
        return serverSuite;
    }

    public static void setDisplayExceptions(boolean tf) {
        _displayExceptions = tf;
    }

    public static boolean getDisplayExceptions() {
        return _displayExceptions;
    }

    public static ServerSuite loginSecondary(String appName, CwmsAuthenticationSource cwmsAuthenticationSource) throws LoginException {
        ServerSuiteFactory factory = ServerSuiteUtil.getFactory();
        if (factory == null) {
            throw new CwmsLoginException("No Server Suite Factory implementation found at runtime. Unable to log into CWMS servers");
        }
        if (!factory.isLoggedIn(cwmsAuthenticationSource)) {
            return factory.loginSecondary(appName, cwmsAuthenticationSource);
        }
        return factory.getInstance(cwmsAuthenticationSource);
    }

    public static CwmsAuthenticationSource replaceWithPreferences(CwmsAuthenticationSource cwmsAuthenticationSource) {
        return CwmsLoginUtil.buildPreferenceServers().stream().filter(c -> c.getDisplayName().equalsIgnoreCase(cwmsAuthenticationSource.getDisplayName())).findFirst().orElse(cwmsAuthenticationSource);
    }

    @ServiceProvider(service=ClientServerUtil.ClientServerService.class)
    public static final class ClientServerServiceImpl
    implements ClientServerUtil.ClientServerService {
        public String getCWMSHome() {
            return ServerSuiteUtil.getCWMSHome();
        }

        public DSSManager getDssManager() {
            return ServerSuiteUtil.getDssManager();
        }

        public Set<String> getLoginListenerUrls() {
            return ServerSuiteUtil.getServerSuite().getLoginListenerUrls();
        }
    }
}

