/*
 * Decompiled with CFR 0.152.
 */
package hec.serversuite.data;

import hec.serversuite.data.ServerInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClientServerInfo
extends ServerInfo {
    public static final Pattern parsingPattern = Pattern.compile("(.*)//(.*):(.*)/(.*)");

    public ClientServerInfo() {
    }

    public ClientServerInfo(String combinedString) {
        this.parseString(combinedString);
    }

    private void parseString(String combinedString) {
        if (combinedString == null) {
            return;
        }
        Matcher m = parsingPattern.matcher((CharSequence)combinedString);
        if (!(m.matches() && m.groupCount() == 4 || (m = parsingPattern.matcher((CharSequence)(combinedString = (String)combinedString + "/"))).matches() && m.groupCount() == 4)) {
            return;
        }
        Object displayName = m.group(1);
        String host = m.group(2);
        String port = m.group(3);
        String serverName = m.group(4);
        if (displayName == null || ((String)displayName).isEmpty()) {
            displayName = host + ":" + port;
        }
        this.setDisplayName((String)displayName);
        this.setHost(host);
        this.setPort(port);
        this.setServerName(serverName);
        this.setExtraColumn1(serverName);
    }

    @Override
    public String getUrl() {
        String url = super.getUrl();
        StringBuilder sb = new StringBuilder(url);
        sb.append("/");
        sb.append(this.getExtraColumn1());
        return sb.toString();
    }
}

