/*
 * Decompiled with CFR 0.152.
 */
package hec.serversuite.data;

import hec.serversuite.data.CwmsAuthenticationSource;
import hec.serversuite.data.CwmsAuthenticationSourcePreferences;
import hec.serversuite.data.CwmsAuthenticationSourceProvider;
import hec.serversuite.data.CwmsLoginUtil;
import hec.serversuite.data.LocalAuthenticationSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import rma.services.annotations.ServiceProvider;
import rma.util.lookup.Lookup;
import rma.util.lookup.Lookups;

@ServiceProvider(service=CwmsAuthenticationSourceProvider.class)
public final class CwmsAuthenticationSourceProviderImpl
implements CwmsAuthenticationSourceProvider {
    private static final Logger LOGGER = Logger.getLogger(CwmsAuthenticationSourceProviderImpl.class.getName());

    public static Optional<CwmsAuthenticationSource> translateAuthenticationSource(Preferences node) {
        return Lookup.getDefault().lookupAll(CwmsAuthenticationSourcePreferences.class).stream().map(c -> c.fromPreferences(node)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    @Override
    public List<CwmsAuthenticationSource> getCwmsAuthenticationSources() {
        ArrayList<CwmsAuthenticationSource> retval = new ArrayList<CwmsAuthenticationSource>();
        Preferences servers = CwmsLoginUtil.getPreferenceNode().node("servers");
        try {
            for (String child : servers.childrenNames()) {
                Preferences node = servers.node(child);
                CwmsAuthenticationSourceProviderImpl.translateAuthenticationSource(node).ifPresent(retval::add);
            }
        }
        catch (BackingStoreException e) {
            LOGGER.log(Level.WARNING, "Unable to access preferences for CWMS login server configuration", e);
        }
        if (CwmsLoginUtil.isLocalLoginAllowed()) {
            retval.add(0, LocalAuthenticationSource.getInstance());
        }
        return retval;
    }

    @Override
    public void saveCwmsAuthenticationSources(List<CwmsAuthenticationSource> cwmsAuthenticationSources) {
        try {
            this.clearPreferences();
            Preferences serverNode = CwmsLoginUtil.getPreferenceNode().node("servers");
            int index = 0;
            block2: for (CwmsAuthenticationSource svInfo : cwmsAuthenticationSources) {
                CwmsAuthenticationSourcePreferences lookup = (CwmsAuthenticationSourcePreferences)Lookups.forPath((String)svInfo.getLookup()).lookup(CwmsAuthenticationSourcePreferences.class);
                if (lookup == null) continue;
                int maxServerCount = 1000;
                while (index < maxServerCount) {
                    String nodeKey = String.format("%03d", index);
                    boolean nodeExists = serverNode.nodeExists(nodeKey);
                    if (nodeExists) {
                        ++index;
                        continue;
                    }
                    Preferences node = serverNode.node(nodeKey);
                    lookup.toPreference(svInfo, node);
                    continue block2;
                }
            }
            serverNode.flush();
        }
        catch (BackingStoreException e) {
            LOGGER.log(Level.WARNING, "Unable to save data sources to preferences", e);
        }
    }

    private void clearPreferences() throws BackingStoreException {
        Preferences serverNode = CwmsLoginUtil.getPreferenceNode().node("servers");
        for (String child : serverNode.childrenNames()) {
            Preferences node = serverNode.node(child);
            boolean foundPreference = Lookup.getDefault().lookupAll(CwmsAuthenticationSourcePreferences.class).stream().map(c -> c.fromPreferences(node)).anyMatch(Optional::isPresent);
            if (!foundPreference) continue;
            node.removeNode();
        }
        serverNode.flush();
    }
}

