/*
 * Decompiled with CFR 0.152.
 */
package hec.serversuite.data;

import hec.serversuite.data.ClientServerInfo;
import hec.serversuite.data.CwmsAuthenticationSource;
import hec.serversuite.data.CwmsAuthenticationSourceProvider;
import hec.serversuite.data.CwmsAuthenticationSourceXml;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import rma.net.HostNameIPChecker;
import rma.util.lookup.Lookup;
import rma.util.lookup.Lookups;

public final class CwmsLoginUtil {
    private static final Preferences PREFERENCE_NODE = Preferences.userRoot().node("mil/army/usace/hec/cwms/login");
    private static final Preferences OLD_PREFERENCE_NODE = Preferences.userRoot().node("hec/login");
    private static final Logger LOGGER = Logger.getLogger(CwmsLoginUtil.class.getName());
    private static boolean LOCAL_LOGIN_ALLOWED = false;

    private CwmsLoginUtil() {
        throw new AssertionError((Object)"Utility class");
    }

    public static Preferences getOldPreferenceNode() {
        return OLD_PREFERENCE_NODE;
    }

    public static Preferences getPreferenceNode() {
        return PREFERENCE_NODE;
    }

    public static boolean isLocalLoginAllowed() {
        return LOCAL_LOGIN_ALLOWED;
    }

    public static void setLocalLoginAllowed(boolean localLoginAllowed) {
        LOCAL_LOGIN_ALLOWED = localLoginAllowed;
    }

    public static List<CwmsAuthenticationSource> buildPreferenceServers() {
        return Lookup.getDefault().lookupAll(CwmsAuthenticationSourceProvider.class).stream().map(CwmsAuthenticationSourceProvider::getCwmsAuthenticationSources).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static String getLastLoginServer() {
        String retval = PREFERENCE_NODE.get("client_last_server", null);
        if (retval == null) {
            retval = CwmsLoginUtil.getOldLastLoginServerName();
        }
        return retval;
    }

    public static void setLastLoginServer(CwmsAuthenticationSource server) {
        PREFERENCE_NODE.put("client_last_server", server.getDisplayName());
    }

    private static String getOldLastLoginServerName() {
        return new ClientServerInfo(OLD_PREFERENCE_NODE.get("client.LastServer", "")).getDisplayName();
    }

    public static String getLastUser() {
        String retval = PREFERENCE_NODE.get("client_last_user", null);
        if (retval == null) {
            retval = CwmsLoginUtil.getOldLastUser();
        }
        return retval;
    }

    public static void setLastUser(String user) {
        PREFERENCE_NODE.put("client_last_user", user);
    }

    private static String getOldLastUser() {
        Preferences preference = OLD_PREFERENCE_NODE.node("hec/login");
        String userName = System.getProperty("user.name", "");
        return preference.get("client.LastLoginUser", userName);
    }

    public static void setLastLoginServerUrls(List<CwmsAuthenticationSource> serverList) {
        Lookup.getDefault().lookupAll(CwmsAuthenticationSourceProvider.class).forEach(s -> s.saveCwmsAuthenticationSources(serverList));
    }

    public static boolean matches(CwmsAuthenticationSource first, CwmsAuthenticationSource second) {
        boolean retval = false;
        if (first == null && second == null) {
            retval = true;
        } else if (Objects.equals(first, second)) {
            retval = true;
        } else if (first != null && second != null) {
            try {
                Object secondUrlString;
                Object firstUrlString = first.getServerInfo().getUrl();
                if (((String)firstUrlString).startsWith("//")) {
                    firstUrlString = "http://" + ((String)firstUrlString).substring(2);
                }
                if (((String)(secondUrlString = second.getServerInfo().getUrl())).startsWith("//")) {
                    secondUrlString = "http://" + ((String)secondUrlString).substring(2);
                }
                URL firstUrl = new URL((String)firstUrlString);
                URL secondUrl = new URL((String)secondUrlString);
                boolean hostsMatch = HostNameIPChecker.areHostsSame((String)firstUrl.getHost(), (String)secondUrl.getHost());
                boolean portsMatch = firstUrl.getPort() == secondUrl.getPort();
                retval = hostsMatch && portsMatch;
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.FINE, "Watershed server url is invalid", e);
            }
        }
        return retval;
    }

    public static Optional<CwmsAuthenticationSource> fromXml(String param) {
        return Lookup.getDefault().lookupAll(CwmsAuthenticationSourceXml.class).stream().filter(c -> param != null && !param.isEmpty()).map(c -> c.fromXml(param)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public static Optional<String> toXml(CwmsAuthenticationSource cwmsAuthenticationSource) {
        Optional<String> retval = Optional.empty();
        CwmsAuthenticationSourceXml lookup = (CwmsAuthenticationSourceXml)Lookups.forPath((String)cwmsAuthenticationSource.getLookup()).lookup(CwmsAuthenticationSourceXml.class);
        if (lookup != null) {
            try {
                retval = Optional.of(lookup.toXml(cwmsAuthenticationSource));
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Unable to serialize to XML, check software configuration", e);
            }
        }
        return retval;
    }
}

